/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.server.solon.integration;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.dromara.mica.mqtt.core.annotation.MqttServerFunction;
import org.dromara.mica.mqtt.core.deserialize.MqttDeserializer;
import org.dromara.mica.mqtt.core.server.MqttServer;
import org.dromara.mica.mqtt.core.server.MqttServerCreator;
import org.dromara.mica.mqtt.core.server.MqttServerCustomizer;
import org.dromara.mica.mqtt.core.server.auth.IMqttServerAuthHandler;
import org.dromara.mica.mqtt.core.server.auth.IMqttServerPublishPermission;
import org.dromara.mica.mqtt.core.server.auth.IMqttServerSubscribeValidator;
import org.dromara.mica.mqtt.core.server.auth.IMqttServerUniqueIdService;
import org.dromara.mica.mqtt.core.server.dispatcher.IMqttMessageDispatcher;
import org.dromara.mica.mqtt.core.server.event.IMqttConnectStatusListener;
import org.dromara.mica.mqtt.core.server.event.IMqttMessageListener;
import org.dromara.mica.mqtt.core.server.event.IMqttSessionListener;
import org.dromara.mica.mqtt.core.server.func.IMqttFunctionMessageListener;
import org.dromara.mica.mqtt.core.server.func.MqttFunctionManager;
import org.dromara.mica.mqtt.core.server.interceptor.IMqttMessageInterceptor;
import org.dromara.mica.mqtt.core.server.session.IMqttSessionManager;
import org.dromara.mica.mqtt.core.server.store.IMqttMessageStore;
import org.dromara.mica.mqtt.core.server.support.DefaultMqttServerAuthHandler;
import org.dromara.mica.mqtt.core.util.TopicUtil;
import org.dromara.mica.mqtt.server.solon.MqttServerTemplate;
import org.dromara.mica.mqtt.server.solon.config.MqttServerConfiguration;
import org.dromara.mica.mqtt.server.solon.config.MqttServerMetricsConfiguration;
import org.dromara.mica.mqtt.server.solon.config.MqttServerProperties;
import org.dromara.mica.mqtt.server.solon.integration.MqttServerFunctionListener;
import org.noear.solon.Solon;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.util.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttServerPluginImpl
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(MqttServerPluginImpl.class);
    private final List<ExtractorClassTag<MqttServerFunction>> functionClassTags = new ArrayList<ExtractorClassTag<MqttServerFunction>>();
    private final List<ExtractorMethodTag<MqttServerFunction>> functionMethodTags = new ArrayList<ExtractorMethodTag<MqttServerFunction>>();
    private volatile boolean running = false;
    private AppContext context;

    public void start(AppContext context) throws Throwable {
        this.context = context;
        context.beanBuilderAdd(MqttServerFunction.class, (clz, beanWrap, anno) -> this.functionClassTags.add(new ExtractorClassTag<MqttServerFunction>(clz, beanWrap, (MqttServerFunction)anno)));
        context.beanExtractorAdd(MqttServerFunction.class, (bw, method, anno) -> this.functionMethodTags.add(new ExtractorMethodTag<MqttServerFunction>(bw, method, (MqttServerFunction)anno)));
        context.lifecycle(-9, () -> {
            context.beanMake(MqttServerProperties.class);
            context.beanMake(MqttServerConfiguration.class);
            MqttServerProperties properties = (MqttServerProperties)context.getBean(MqttServerProperties.class);
            MqttServerCreator serverCreator = (MqttServerCreator)context.getBean(MqttServerCreator.class);
            IMqttServerAuthHandler authHandlerImpl = (IMqttServerAuthHandler)context.getBean(IMqttServerAuthHandler.class);
            IMqttServerUniqueIdService uniqueIdService = (IMqttServerUniqueIdService)context.getBean(IMqttServerUniqueIdService.class);
            IMqttServerSubscribeValidator subscribeValidator = (IMqttServerSubscribeValidator)context.getBean(IMqttServerSubscribeValidator.class);
            IMqttServerPublishPermission publishPermission = (IMqttServerPublishPermission)context.getBean(IMqttServerPublishPermission.class);
            IMqttMessageDispatcher messageDispatcher = (IMqttMessageDispatcher)context.getBean(IMqttMessageDispatcher.class);
            IMqttMessageStore messageStore = (IMqttMessageStore)context.getBean(IMqttMessageStore.class);
            IMqttSessionManager sessionManager = (IMqttSessionManager)context.getBean(IMqttSessionManager.class);
            IMqttSessionListener sessionListener = (IMqttSessionListener)context.getBean(IMqttSessionListener.class);
            IMqttMessageListener messageListener = (IMqttMessageListener)context.getBean(IMqttMessageListener.class);
            IMqttConnectStatusListener connectStatusListener = (IMqttConnectStatusListener)context.getBean(IMqttConnectStatusListener.class);
            IMqttMessageInterceptor messageInterceptor = (IMqttMessageInterceptor)context.getBean(IMqttMessageInterceptor.class);
            MqttServerCustomizer customizers = (MqttServerCustomizer)context.getBean(MqttServerCustomizer.class);
            serverCreator.messageListener(messageListener);
            MqttServerProperties.MqttAuth mqttAuth = properties.getAuth();
            if (Objects.isNull(authHandlerImpl)) {
                DefaultMqttServerAuthHandler authHandler = mqttAuth.isEnable() ? new DefaultMqttServerAuthHandler(mqttAuth.getUsername(), mqttAuth.getPassword()) : null;
                serverCreator.authHandler((IMqttServerAuthHandler)authHandler);
            } else {
                serverCreator.authHandler(authHandlerImpl);
            }
            if (Objects.nonNull(uniqueIdService)) {
                serverCreator.uniqueIdService(uniqueIdService);
            }
            if (Objects.nonNull(subscribeValidator)) {
                serverCreator.subscribeValidator(subscribeValidator);
            }
            if (Objects.nonNull(publishPermission)) {
                serverCreator.publishPermission(publishPermission);
            }
            if (Objects.nonNull(messageDispatcher)) {
                serverCreator.messageDispatcher(messageDispatcher);
            }
            if (Objects.nonNull(messageStore)) {
                serverCreator.messageStore(messageStore);
            }
            if (Objects.nonNull(sessionManager)) {
                serverCreator.sessionManager(sessionManager);
            }
            if (Objects.nonNull(sessionListener)) {
                serverCreator.sessionListener(sessionListener);
            }
            if (Objects.nonNull(connectStatusListener)) {
                serverCreator.connectStatusListener(connectStatusListener);
            }
            if (Objects.nonNull(messageInterceptor)) {
                serverCreator.addInterceptor(messageInterceptor);
            }
            if (Objects.nonNull(customizers)) {
                customizers.customize(serverCreator);
            }
            MqttServer mqttServer = serverCreator.build();
            MqttServerTemplate mqttServerTemplate = new MqttServerTemplate(mqttServer);
            context.wrapAndPut(MqttServerTemplate.class, (Object)mqttServerTemplate);
            context.beanMake(MqttServerMetricsConfiguration.class);
            this.functionDetector();
            if (properties.isEnabled() && !this.running) {
                this.running = mqttServerTemplate.getMqttServer().start();
                log.info("mqtt server start...");
            }
        });
    }

    private void functionDetector() {
        MqttFunctionManager functionManager = (MqttFunctionManager)this.context.getBean(MqttFunctionManager.class);
        this.functionClassTags.forEach(each -> {
            MqttServerFunction anno = (MqttServerFunction)each.getAnno();
            String[] topicFilters = this.getTopicFilters(anno.value());
            IMqttFunctionMessageListener messageListener = (IMqttFunctionMessageListener)each.getBeanWrap().get();
            functionManager.register(topicFilters, messageListener);
        });
        this.functionMethodTags.forEach(each -> {
            MqttServerFunction anno = (MqttServerFunction)each.getAnno();
            String[] topicTemplates = anno.value();
            String[] topicFilters = this.getTopicFilters(topicTemplates);
            Class deserialized = anno.deserialize();
            MqttDeserializer deserializer = this.getMqttDeserializer(deserialized);
            Object bean = each.getBw().get();
            Method method = each.getMethod();
            MqttServerFunctionListener functionListener = new MqttServerFunctionListener(bean, method, topicTemplates, topicFilters, deserializer);
            functionManager.register(topicFilters, (IMqttFunctionMessageListener)functionListener);
        });
    }

    private MqttDeserializer getMqttDeserializer(Class<?> deserializerType) {
        BeanWrap beanWrap = this.context.getWrap(deserializerType);
        if (beanWrap == null) {
            return (MqttDeserializer)ClassUtil.newInstance(deserializerType);
        }
        return (MqttDeserializer)beanWrap.get();
    }

    private String[] getTopicFilters(String[] topicTemplates) {
        return (String[])Arrays.stream(topicTemplates).map(x -> Optional.ofNullable(Solon.cfg().getByTmpl(x)).orElse((String)x)).map(TopicUtil::getTopicFilter).toArray(String[]::new);
    }

    public void stop() {
        if (this.running) {
            MqttServerTemplate mqttServerTemplate = (MqttServerTemplate)this.context.getBean(MqttServerTemplate.class);
            mqttServerTemplate.getMqttServer().stop();
            log.info("mqtt server stop...");
        }
    }

    private static class ExtractorMethodTag<T> {
        private final BeanWrap bw;
        private final Method method;
        private final T anno;

        public BeanWrap getBw() {
            return this.bw;
        }

        public Method getMethod() {
            return this.method;
        }

        public T getAnno() {
            return this.anno;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExtractorMethodTag)) {
                return false;
            }
            ExtractorMethodTag other = (ExtractorMethodTag)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BeanWrap this$bw = this.getBw();
            BeanWrap other$bw = other.getBw();
            if (this$bw == null ? other$bw != null : !this$bw.equals(other$bw)) {
                return false;
            }
            Method this$method = this.getMethod();
            Method other$method = other.getMethod();
            if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
                return false;
            }
            T this$anno = this.getAnno();
            T other$anno = other.getAnno();
            return !(this$anno == null ? other$anno != null : !this$anno.equals(other$anno));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExtractorMethodTag;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BeanWrap $bw = this.getBw();
            result = result * 59 + ($bw == null ? 43 : $bw.hashCode());
            Method $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            T $anno = this.getAnno();
            result = result * 59 + ($anno == null ? 43 : $anno.hashCode());
            return result;
        }

        public String toString() {
            return "MqttServerPluginImpl.ExtractorMethodTag(bw=" + this.getBw() + ", method=" + this.getMethod() + ", anno=" + this.getAnno() + ")";
        }

        public ExtractorMethodTag(BeanWrap bw, Method method, T anno) {
            this.bw = bw;
            this.method = method;
            this.anno = anno;
        }
    }

    private static class ExtractorClassTag<T> {
        private final Class<?> clz;
        private final BeanWrap beanWrap;
        private final T anno;

        public Class<?> getClz() {
            return this.clz;
        }

        public BeanWrap getBeanWrap() {
            return this.beanWrap;
        }

        public T getAnno() {
            return this.anno;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExtractorClassTag)) {
                return false;
            }
            ExtractorClassTag other = (ExtractorClassTag)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$clz = this.getClz();
            Class<?> other$clz = other.getClz();
            if (this$clz == null ? other$clz != null : !this$clz.equals(other$clz)) {
                return false;
            }
            BeanWrap this$beanWrap = this.getBeanWrap();
            BeanWrap other$beanWrap = other.getBeanWrap();
            if (this$beanWrap == null ? other$beanWrap != null : !this$beanWrap.equals(other$beanWrap)) {
                return false;
            }
            T this$anno = this.getAnno();
            T other$anno = other.getAnno();
            return !(this$anno == null ? other$anno != null : !this$anno.equals(other$anno));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExtractorClassTag;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $clz = this.getClz();
            result = result * 59 + ($clz == null ? 43 : $clz.hashCode());
            BeanWrap $beanWrap = this.getBeanWrap();
            result = result * 59 + ($beanWrap == null ? 43 : $beanWrap.hashCode());
            T $anno = this.getAnno();
            result = result * 59 + ($anno == null ? 43 : $anno.hashCode());
            return result;
        }

        public String toString() {
            return "MqttServerPluginImpl.ExtractorClassTag(clz=" + this.getClz() + ", beanWrap=" + this.getBeanWrap() + ", anno=" + this.getAnno() + ")";
        }

        public ExtractorClassTag(Class<?> clz, BeanWrap beanWrap, T anno) {
            this.clz = clz;
            this.beanWrap = beanWrap;
            this.anno = anno;
        }
    }
}

