/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.processor;

import com.google.auto.service.AutoService;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.dromara.milvus.plus.annotation.MilvusField;

@SupportedAnnotationTypes(value={"org.dromara.milvus.plus.annotation.GenerateMilvusMapper"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@AutoService(value={Processor.class})
public class GenerateMilvusMapperProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                if (element.getKind() != ElementKind.CLASS) continue;
                TypeElement typeElement2 = (TypeElement)element;
                this.generateMilvusMapperClass(typeElement2);
                this.generateConstantsClass(typeElement2);
            }
        }
        return true;
    }

    private void generateMilvusMapperClass(TypeElement typeElement) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        String packageName = elementUtils.getPackageOf(typeElement).getQualifiedName().toString();
        String className = typeElement.getSimpleName().toString();
        String mapperClassName = className + "MilvusMapper";
        ClassName entityTypeName = ClassName.get((String)packageName, (String)className, (String[])new String[0]);
        TypeSpec mapperClass = TypeSpec.classBuilder((String)mapperClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.dromara.milvus.plus.mapper", (String)"MilvusMapper", (String[])new String[0]), (TypeName[])new TypeName[]{entityTypeName})).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"org.springframework.stereotype", (String)"Component", (String[])new String[0])).build()).build();
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)mapperClass).addFileComment("Generated by @GenerateMilvusMapper", new Object[0]).build();
        try {
            javaFile.writeTo(this.processingEnv.getFiler());
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error generating Milvus mapper class: " + e.getMessage(), typeElement);
        }
    }

    private void generateConstantsClass(TypeElement typeElement) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        String packageName = elementUtils.getPackageOf(typeElement).getQualifiedName().toString();
        String className = typeElement.getSimpleName().toString();
        String constantsClassName = className + "Constants";
        ArrayList<FieldSpec> constantsFields = new ArrayList<FieldSpec>();
        for (Element element : typeElement.getEnclosedElements()) {
            VariableElement field;
            MilvusField milvusField;
            if (element.getKind() != ElementKind.FIELD || (milvusField = (field = (VariableElement)element).getAnnotation(MilvusField.class)) == null) continue;
            String constantName = !milvusField.name().isEmpty() ? milvusField.name() : field.getSimpleName().toString();
            String upperCaseConstantName = constantName.toUpperCase();
            constantsFields.add(FieldSpec.builder(String.class, (String)upperCaseConstantName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{constantName}).build());
        }
        if (!constantsFields.isEmpty()) {
            TypeSpec constantsClass = TypeSpec.classBuilder((String)constantsClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addFields(constantsFields).build();
            JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)constantsClass).addFileComment("Generated by @GenerateMilvusMapperProcessor", new Object[0]).build();
            try {
                javaFile.writeTo(this.processingEnv.getFiler());
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error generating constants class: " + e.getMessage(), typeElement);
            }
        }
    }
}

