/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.service;

import io.milvus.v2.client.MilvusClientV2;
import org.dromara.milvus.plus.config.MilvusPropertiesConfiguration;
import org.dromara.milvus.plus.log.LogLevelController;
import org.dromara.milvus.plus.model.MilvusProperties;
import org.dromara.milvus.plus.service.AbstractMilvusClientBuilder;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;

@Service
public class MilvusInit
extends AbstractMilvusClientBuilder
implements InitializingBean,
DisposableBean {
    private final MilvusPropertiesConfiguration milvusPropertiesConfiguration;
    private MilvusClientV2 client;

    public MilvusInit(MilvusPropertiesConfiguration milvusPropertiesConfiguration) {
        this.milvusPropertiesConfiguration = milvusPropertiesConfiguration;
    }

    public void afterPropertiesSet() {
        this.initialize();
    }

    public void destroy() throws Exception {
    }

    public void initialize() {
        this.maybePrintBanner();
        LogLevelController.setLoggingEnabledForPackage((String)"org.dromara.milvus.plus", (boolean)this.milvusPropertiesConfiguration.isOpenLog(), (String)this.milvusPropertiesConfiguration.getLogLevel());
        MilvusProperties milvusProperties = new MilvusProperties();
        BeanUtils.copyProperties((Object)this.milvusPropertiesConfiguration, (Object)milvusProperties);
        super.setProperties(milvusProperties);
        super.initialize();
        this.client = this.getClient();
    }

    @Bean
    public MilvusClientV2 milvusClientV2() {
        return this.client;
    }

    public void maybePrintBanner() {
        if (this.milvusPropertiesConfiguration.isBanner()) {
            this.printBanner();
        }
    }

    public void printBanner() {
        String banner = "  __  __ _ _                    ____  _           \n |  \\/  (_) |_   ___   _ ___   |  _ \\| |_   _ ___ \n | |\\/| | | \\ \\ / / | | / __|  | |_) | | | | / __|\n | |  | | | |\\ V /| |_| \\__ \\  |  __/| | |_| \\__ \\\n |_|  |_|_|_| \\_/  \\__,_|___/  |_|   |_|\\__,_|___/\n\n";
        System.out.println(banner);
    }
}

