/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.service;

import io.milvus.v2.client.MilvusClientV2;
import io.milvus.v2.service.vector.response.DeleteResp;
import io.milvus.v2.service.vector.response.InsertResp;
import io.milvus.v2.service.vector.response.UpsertResp;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.dromara.milvus.plus.core.conditions.LambdaDeleteWrapper;
import org.dromara.milvus.plus.core.conditions.LambdaInsertWrapper;
import org.dromara.milvus.plus.core.conditions.LambdaQueryWrapper;
import org.dromara.milvus.plus.core.conditions.LambdaUpdateWrapper;
import org.dromara.milvus.plus.core.conditions.Wrapper;
import org.dromara.milvus.plus.core.mapper.BaseMilvusMapper;
import org.dromara.milvus.plus.model.vo.MilvusResp;
import org.dromara.milvus.plus.model.vo.MilvusResult;
import org.dromara.milvus.plus.service.IAMService;
import org.dromara.milvus.plus.service.ICMService;
import org.dromara.milvus.plus.service.IVecMService;
import org.dromara.milvus.plus.util.MilvusSpringUtils;
import org.springframework.stereotype.Service;

@Service
public class MilvusService
implements IAMService,
ICMService,
IVecMService {
    public MilvusClientV2 getClient() {
        return MilvusSpringUtils.getBean(MilvusClientV2.class);
    }

    public <T> MilvusResp<List<MilvusResult<T>>> getById(Class<T> entityClass, Serializable ... ids) {
        BaseMilvusMapper<T> mapper = this.getBaseMilvusMapper();
        LambdaQueryWrapper lambda = (LambdaQueryWrapper)mapper.lambda(entityClass, (Wrapper)new LambdaQueryWrapper());
        return lambda.getById(ids);
    }

    public <T> MilvusResp<DeleteResp> removeById(Class<T> entityClass, Serializable ... ids) {
        BaseMilvusMapper<T> mapper = this.getBaseMilvusMapper();
        LambdaDeleteWrapper lambda = (LambdaDeleteWrapper)mapper.lambda(entityClass, (Wrapper)new LambdaDeleteWrapper());
        return lambda.removeById(ids);
    }

    public <T> MilvusResp<InsertResp> insert(T ... entities) {
        Class<T> entityClass = this.getEntityClass(entities[0]);
        BaseMilvusMapper<T> mapper = this.getBaseMilvusMapper();
        LambdaInsertWrapper lambda = (LambdaInsertWrapper)mapper.lambda(entityClass, (Wrapper)new LambdaInsertWrapper());
        return lambda.insert((Object[])entities);
    }

    public <T> MilvusResp<InsertResp> insert(Collection<T> entities) {
        T entity = entities.iterator().next();
        Class<T> entityClass = this.getEntityClass(entity);
        BaseMilvusMapper<T> mapper = this.getBaseMilvusMapper();
        LambdaInsertWrapper lambda = (LambdaInsertWrapper)mapper.lambda(entityClass, (Wrapper)new LambdaInsertWrapper());
        return lambda.insert(entities.iterator());
    }

    public <T> MilvusResp<UpsertResp> updateById(T ... entities) {
        Class<T> entityClass = this.getEntityClass(entities[0]);
        BaseMilvusMapper<T> mapper = this.getBaseMilvusMapper();
        LambdaUpdateWrapper lambda = (LambdaUpdateWrapper)mapper.lambda(entityClass, (Wrapper)new LambdaUpdateWrapper());
        return lambda.updateById((Object[])entities);
    }

    public <T> MilvusResp<UpsertResp> updateById(Collection<T> entities) {
        T entity = entities.iterator().next();
        Class<T> entityClass = this.getEntityClass(entity);
        BaseMilvusMapper<T> mapper = this.getBaseMilvusMapper();
        LambdaUpdateWrapper lambda = (LambdaUpdateWrapper)mapper.lambda(entityClass, (Wrapper)new LambdaUpdateWrapper());
        return lambda.updateById(entities.iterator());
    }

    public <T> LambdaUpdateWrapper ofUpdate(Class<T> entityClass) {
        BaseMilvusMapper<T> mapper = this.getBaseMilvusMapper();
        LambdaUpdateWrapper lambda = (LambdaUpdateWrapper)mapper.lambda(entityClass, (Wrapper)new LambdaUpdateWrapper());
        return lambda;
    }

    public <T> LambdaInsertWrapper ofInsert(Class<T> entityClass) {
        BaseMilvusMapper<T> mapper = this.getBaseMilvusMapper();
        LambdaInsertWrapper lambda = (LambdaInsertWrapper)mapper.lambda(entityClass, (Wrapper)new LambdaInsertWrapper());
        return lambda;
    }

    public <T> LambdaDeleteWrapper ofDelete(Class<T> entityClass) {
        BaseMilvusMapper<T> mapper = this.getBaseMilvusMapper();
        LambdaDeleteWrapper lambda = (LambdaDeleteWrapper)mapper.lambda(entityClass, (Wrapper)new LambdaDeleteWrapper());
        return lambda;
    }

    public <T> LambdaQueryWrapper ofQuery(Class<T> entityClass) {
        BaseMilvusMapper<T> mapper = this.getBaseMilvusMapper();
        LambdaQueryWrapper lambda = (LambdaQueryWrapper)mapper.lambda(entityClass, (Wrapper)new LambdaQueryWrapper());
        return lambda;
    }

    private <T> BaseMilvusMapper<T> getBaseMilvusMapper() {
        final MilvusClientV2 client = this.getClient();
        return new BaseMilvusMapper<T>(){

            public MilvusClientV2 getClient() {
                return client;
            }
        };
    }

    private <T> Class<T> getEntityClass(T entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity must not be null");
        }
        return entity.getClass();
    }
}

