/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.core.conditions;

import io.milvus.exception.MilvusException;
import io.milvus.v2.client.MilvusClientV2;
import io.milvus.v2.common.ConsistencyLevel;
import io.milvus.v2.service.vector.request.AnnSearchReq;
import io.milvus.v2.service.vector.request.GetReq;
import io.milvus.v2.service.vector.request.HybridSearchReq;
import io.milvus.v2.service.vector.request.QueryReq;
import io.milvus.v2.service.vector.request.SearchReq;
import io.milvus.v2.service.vector.request.data.BaseVector;
import io.milvus.v2.service.vector.request.data.FloatVec;
import io.milvus.v2.service.vector.request.ranker.BaseRanker;
import io.milvus.v2.service.vector.response.GetResp;
import io.milvus.v2.service.vector.response.QueryResp;
import io.milvus.v2.service.vector.response.SearchResp;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dromara.milvus.plus.cache.ConversionCache;
import org.dromara.milvus.plus.converter.SearchRespConverter;
import org.dromara.milvus.plus.core.FieldFunction;
import org.dromara.milvus.plus.core.conditions.AbstractChainWrapper;
import org.dromara.milvus.plus.core.conditions.ConditionBuilder;
import org.dromara.milvus.plus.core.conditions.Wrapper;
import org.dromara.milvus.plus.model.vo.MilvusResp;
import org.dromara.milvus.plus.model.vo.MilvusResult;
import org.dromara.milvus.plus.util.GsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class LambdaQueryWrapper<T>
extends AbstractChainWrapper<T>
implements Wrapper<LambdaQueryWrapper<T>, T> {
    private static final Logger log = LoggerFactory.getLogger(LambdaQueryWrapper.class);
    private ConversionCache conversionCache;
    private List<String> outputFields;
    private Class<T> entityType;
    private String collectionName;
    private String collectionAlias;
    private List<String> partitionNames = new ArrayList<String>();
    private String annsField;
    private int topK;
    private List<BaseVector> vectors = new ArrayList<BaseVector>();
    private long offset;
    private long limit;
    private int roundDecimal = -1;
    private long guaranteeTimestamp;
    private ConsistencyLevel consistencyLevel;
    private boolean ignoreGrowing;
    private MilvusClientV2 client;
    private Map<String, Object> searchParams = new HashMap<String, Object>(16);
    private List<LambdaQueryWrapper<T>> hybridWrapper = new ArrayList<LambdaQueryWrapper<T>>();
    private BaseRanker ranker;

    public LambdaQueryWrapper<T> hybrid(LambdaQueryWrapper<T> wrapper) {
        this.hybridWrapper.add(wrapper);
        return this;
    }

    public LambdaQueryWrapper<T> alias(String collectionAlias) {
        this.collectionAlias = collectionAlias;
        return this;
    }

    public LambdaQueryWrapper<T> partition(String ... partitionName) {
        this.partitionNames.addAll(Arrays.asList(partitionName));
        return this;
    }

    public LambdaQueryWrapper<T> consistencyLevel(ConsistencyLevel level) {
        this.consistencyLevel = level;
        return this;
    }

    public LambdaQueryWrapper<T> partition(FieldFunction<T, ?> ... partitionName) {
        AbstractChainWrapper.ArrayIterator iterator = new AbstractChainWrapper.ArrayIterator(partitionName);
        while (iterator.hasNext()) {
            FieldFunction p = (FieldFunction)iterator.next();
            this.partitionNames.add(p.getFieldName(p));
        }
        return this;
    }

    public LambdaQueryWrapper<T> partition(Collection<FieldFunction<T, ?>> partitionName) {
        if (CollectionUtils.isEmpty(partitionName)) {
            throw new RuntimeException("partition collection is empty");
        }
        partitionName.forEach(f -> this.partitionNames.add(f.getFieldName(f)));
        return this;
    }

    public LambdaQueryWrapper<T> searchParams(Map<String, Object> searchParams) {
        this.searchParams.putAll(searchParams);
        return this;
    }

    public LambdaQueryWrapper<T> radius(Object radius) {
        this.searchParams.put("radius", radius);
        return this;
    }

    public LambdaQueryWrapper<T> rangeFilter(Object rangeFilter) {
        this.searchParams.put("range_filter", rangeFilter);
        return this;
    }

    public LambdaQueryWrapper<T> metricType(Object metric_type) {
        this.searchParams.put("metric_type", metric_type);
        return this;
    }

    public LambdaQueryWrapper<T> roundDecimal(int roundDecimal) {
        this.roundDecimal = roundDecimal;
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> eq(String fieldName, Object value) {
        super.eq(fieldName, value);
        return this;
    }

    public LambdaQueryWrapper<T> eq(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.eq(fieldName, value);
        }
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> ne(String fieldName, Object value) {
        super.ne(fieldName, value);
        return this;
    }

    public LambdaQueryWrapper<T> ne(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.ne(fieldName, value);
        }
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> gt(String fieldName, Object value) {
        super.gt(fieldName, value);
        return this;
    }

    public LambdaQueryWrapper<T> gt(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.gt(fieldName, value);
        }
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> ge(String fieldName, Object value) {
        super.ge(fieldName, value);
        return this;
    }

    public LambdaQueryWrapper<T> ge(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.ge(fieldName, value);
        }
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> lt(String fieldName, Object value) {
        super.lt(fieldName, value);
        return this;
    }

    public LambdaQueryWrapper<T> lt(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.lt(fieldName, value);
        }
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> le(String fieldName, Object value) {
        super.le(fieldName, value);
        return this;
    }

    public LambdaQueryWrapper<T> le(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.le(fieldName, value);
        }
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> between(String fieldName, Object start, Object end) {
        super.between(fieldName, start, end);
        return this;
    }

    public LambdaQueryWrapper<T> between(boolean condition, String fieldName, Object start, Object end) {
        if (condition) {
            super.between(fieldName, start, end);
        }
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> isNull(String fieldName) {
        super.isNull(fieldName);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> isNotNull(String fieldName) {
        super.isNotNull(fieldName);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> in(String fieldName, List<?> values) {
        super.in(fieldName, values);
        return this;
    }

    public LambdaQueryWrapper<T> in(boolean condition, String fieldName, List<?> values) {
        if (condition) {
            super.in(fieldName, values);
        }
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> like(String fieldName, String value) {
        super.like(fieldName, value);
        return this;
    }

    public LambdaQueryWrapper<T> like(boolean condition, String fieldName, String value) {
        if (condition) {
            super.like(fieldName, value);
        }
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> like(FieldFunction<T, ?> fieldName, String value) {
        super.like(fieldName, value);
        return this;
    }

    public LambdaQueryWrapper<T> like(boolean condition, FieldFunction<T, ?> fieldName, String value) {
        if (condition) {
            super.like(fieldName, value);
        }
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> likeLeft(String fieldName, String value) {
        super.likeLeft(fieldName, value);
        return this;
    }

    public LambdaQueryWrapper<T> likeLeft(boolean condition, String fieldName, String value) {
        if (condition) {
            super.likeLeft(fieldName, value);
        }
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> likeLeft(FieldFunction<T, ?> fieldName, String value) {
        super.likeLeft(fieldName, value);
        return this;
    }

    public LambdaQueryWrapper<T> likeLeft(boolean condition, FieldFunction<T, ?> fieldName, String value) {
        if (condition) {
            super.likeLeft(fieldName, value);
        }
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> likeRight(String fieldName, String value) {
        super.likeRight(fieldName, value);
        return this;
    }

    public LambdaQueryWrapper<T> likeRight(boolean condition, String fieldName, String value) {
        if (condition) {
            super.likeRight(fieldName, value);
        }
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> likeRight(FieldFunction<T, ?> fieldName, String value) {
        super.likeRight(fieldName, value);
        return this;
    }

    public LambdaQueryWrapper<T> likeRight(boolean condition, FieldFunction<T, ?> fieldName, String value) {
        if (condition) {
            super.likeRight(fieldName, value);
        }
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> jsonContains(String fieldName, Object value) {
        super.jsonContains(fieldName, value);
        return this;
    }

    public LambdaQueryWrapper<T> jsonContains(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.jsonContains(fieldName, value);
        }
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> jsonContainsAll(String fieldName, List<?> values) {
        super.jsonContainsAll(fieldName, values);
        return this;
    }

    public LambdaQueryWrapper<T> jsonContainsAll(boolean condition, String fieldName, List<?> values) {
        if (condition) {
            super.jsonContainsAll(fieldName, values);
        }
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> jsonContainsAny(String fieldName, List<?> values) {
        super.jsonContainsAny(fieldName, values);
        return this;
    }

    public LambdaQueryWrapper<T> jsonContainsAny(boolean condition, String fieldName, List<?> values) {
        if (condition) {
            super.jsonContainsAny(fieldName, values);
        }
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> arrayContains(String fieldName, Object value) {
        super.arrayContains(fieldName, value);
        return this;
    }

    public LambdaQueryWrapper<T> arrayContains(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.arrayContains(fieldName, value);
        }
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> arrayContainsAll(String fieldName, List<?> values) {
        super.arrayContainsAll(fieldName, values);
        return this;
    }

    public LambdaQueryWrapper<T> arrayContainsAll(boolean condition, String fieldName, List<?> values) {
        if (condition) {
            super.arrayContainsAll(fieldName, values);
        }
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> arrayContainsAny(String fieldName, List<?> values) {
        super.arrayContainsAny(fieldName, values);
        return this;
    }

    public LambdaQueryWrapper<T> arrayContainsAny(boolean condition, String fieldName, List<?> values) {
        if (condition) {
            super.arrayContainsAny(fieldName, values);
        }
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> arrayLength(String fieldName, int length) {
        super.arrayLength(fieldName, length);
        return this;
    }

    public LambdaQueryWrapper<T> arrayLength(boolean condition, String fieldName, int length) {
        if (condition) {
            super.arrayLength(fieldName, length);
        }
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> eq(FieldFunction<T, ?> fieldName, Object value) {
        super.eq(fieldName, value);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> ne(FieldFunction<T, ?> fieldName, Object value) {
        super.ne(fieldName, value);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> gt(FieldFunction<T, ?> fieldName, Object value) {
        super.gt(fieldName, value);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> ge(FieldFunction<T, ?> fieldName, Object value) {
        super.ge(fieldName, value);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> lt(FieldFunction<T, ?> fieldName, Object value) {
        super.lt(fieldName, value);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> le(FieldFunction<T, ?> fieldName, Object value) {
        super.le(fieldName, value);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> between(FieldFunction<T, ?> fieldName, Object start, Object end) {
        super.between(fieldName, start, end);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> isNull(FieldFunction<T, ?> fieldName) {
        super.isNull(fieldName);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> isNotNull(FieldFunction<T, ?> fieldName) {
        super.isNotNull(fieldName);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> in(FieldFunction<T, ?> fieldName, List<?> values) {
        super.in(fieldName, values);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> jsonContains(FieldFunction<T, ?> fieldName, Object value) {
        super.jsonContains(fieldName, value);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> jsonContainsAll(FieldFunction<T, ?> fieldName, List<?> values) {
        super.jsonContainsAll(fieldName, values);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> jsonContainsAny(FieldFunction<T, ?> fieldName, List<?> values) {
        super.jsonContainsAny(fieldName, values);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> arrayContains(FieldFunction<T, ?> fieldName, Object value) {
        super.arrayContains(fieldName, value);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> arrayContainsAll(FieldFunction<T, ?> fieldName, List<?> values) {
        super.arrayContainsAll(fieldName, values);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> arrayContainsAny(FieldFunction<T, ?> fieldName, List<?> values) {
        super.arrayContainsAny(fieldName, values);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> arrayLength(FieldFunction<T, ?> fieldName, int length) {
        super.arrayLength(fieldName, length);
        return this;
    }

    public LambdaQueryWrapper<T> eq(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.eq(fieldName, value);
        }
        return this;
    }

    public LambdaQueryWrapper<T> ne(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.ne(fieldName, value);
        }
        return this;
    }

    public LambdaQueryWrapper<T> gt(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.gt(fieldName, value);
        }
        return this;
    }

    public LambdaQueryWrapper<T> ge(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.ge(fieldName, value);
        }
        return this;
    }

    public LambdaQueryWrapper<T> lt(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.lt(fieldName, value);
        }
        return this;
    }

    public LambdaQueryWrapper<T> le(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.le(fieldName, value);
        }
        return this;
    }

    public LambdaQueryWrapper<T> between(boolean condition, FieldFunction<T, ?> fieldName, Object start, Object end) {
        if (condition) {
            super.between(fieldName, start, end);
        }
        return this;
    }

    public LambdaQueryWrapper<T> in(boolean condition, FieldFunction<T, ?> fieldName, List<?> values) {
        if (condition) {
            super.in(fieldName, values);
        }
        return this;
    }

    public LambdaQueryWrapper<T> jsonContains(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.jsonContains(fieldName, value);
        }
        return this;
    }

    public LambdaQueryWrapper<T> jsonContainsAll(boolean condition, FieldFunction<T, ?> fieldName, List<?> values) {
        if (condition) {
            super.jsonContainsAll(fieldName, values);
        }
        return this;
    }

    public LambdaQueryWrapper<T> jsonContainsAny(boolean condition, FieldFunction<T, ?> fieldName, List<?> values) {
        if (condition) {
            super.jsonContainsAny(fieldName, values);
        }
        return this;
    }

    public LambdaQueryWrapper<T> arrayContains(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.arrayContains(fieldName, value);
        }
        return this;
    }

    public LambdaQueryWrapper<T> arrayContainsAll(boolean condition, FieldFunction<T, ?> fieldName, List<?> values) {
        if (condition) {
            super.arrayContainsAll(fieldName, values);
        }
        return this;
    }

    public LambdaQueryWrapper<T> arrayContainsAny(boolean condition, FieldFunction<T, ?> fieldName, List<?> values) {
        if (condition) {
            super.arrayContainsAny(fieldName, values);
        }
        return this;
    }

    public LambdaQueryWrapper<T> arrayLength(boolean condition, FieldFunction<T, ?> fieldName, int length) {
        if (condition) {
            super.arrayLength(fieldName, length);
        }
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> and(ConditionBuilder<T> other) {
        super.and(other);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> or(ConditionBuilder<T> other) {
        super.or(other);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> not() {
        super.not();
        return this;
    }

    public LambdaQueryWrapper<T> annsField(String annsField) {
        this.annsField = annsField;
        return this;
    }

    public LambdaQueryWrapper<T> annsField(FieldFunction<T, ?> annsField) {
        this.annsField = annsField.getFieldName(annsField);
        return this;
    }

    public LambdaQueryWrapper<T> ranker(BaseRanker ranker) {
        this.ranker = ranker;
        return this;
    }

    public LambdaQueryWrapper<T> vector(List<Float> vector) {
        FloatVec baseVector = new FloatVec(vector);
        this.vectors.add((BaseVector)baseVector);
        return this;
    }

    public LambdaQueryWrapper<T> vector(String annsField, List<Float> vector) {
        this.annsField = annsField;
        FloatVec baseVector = new FloatVec(vector);
        this.vectors.add((BaseVector)baseVector);
        return this;
    }

    public LambdaQueryWrapper<T> vector(FieldFunction<T, ?> annsField, List<? extends Float> vector) {
        this.annsField = annsField.getFieldName(annsField);
        FloatVec baseVector = new FloatVec(vector);
        this.vectors.add((BaseVector)baseVector);
        return this;
    }

    public LambdaQueryWrapper<T> vector(BaseVector vector) {
        this.vectors.add(vector);
        return this;
    }

    public LambdaQueryWrapper<T> vector(String annsField, BaseVector vector) {
        this.annsField = annsField;
        this.vectors.add(vector);
        return this;
    }

    public LambdaQueryWrapper<T> vector(FieldFunction<T, ?> annsField, BaseVector vector) {
        this.annsField = annsField.getFieldName(annsField);
        this.vectors.add(vector);
        return this;
    }

    public LambdaQueryWrapper<T> limit(Long limit) {
        this.setLimit(limit);
        return this;
    }

    public LambdaQueryWrapper<T> offset(Long offset) {
        this.setOffset(offset);
        return this;
    }

    public LambdaQueryWrapper<T> topK(Integer topK) {
        this.setTopK(topK);
        return this;
    }

    private SearchReq buildSearch() {
        String filterStr;
        SearchReq.SearchReqBuilder builder = SearchReq.builder().collectionName(StringUtils.isNotBlank((CharSequence)this.collectionAlias) ? this.collectionAlias : this.collectionName);
        if (this.annsField != null && !this.annsField.isEmpty()) {
            builder.annsField(this.annsField);
        }
        if (this.consistencyLevel != null) {
            builder.consistencyLevel(this.consistencyLevel);
        }
        if (!this.vectors.isEmpty()) {
            builder.data(this.vectors);
        }
        if ((filterStr = this.buildFilters()) != null && !filterStr.isEmpty()) {
            builder.filter(filterStr);
        }
        if (this.topK > 0) {
            builder.topK(this.topK);
        }
        if (this.limit > 0L) {
            builder.limit(this.limit);
        }
        if (this.offset > 0L) {
            builder.offset(this.offset);
        }
        if (!CollectionUtils.isEmpty(this.partitionNames)) {
            builder.partitionNames(this.partitionNames);
        }
        if (this.outputFields != null && !this.outputFields.isEmpty()) {
            builder.outputFields(this.outputFields);
        } else {
            Collection<String> values = this.conversionCache.getPropertyCache().functionToPropertyMap.values();
            builder.outputFields(new ArrayList<String>(values));
        }
        if (!this.searchParams.isEmpty()) {
            builder.searchParams(this.searchParams);
        }
        if (this.roundDecimal != -1) {
            builder.roundDecimal(this.roundDecimal);
        }
        return builder.build();
    }

    private QueryReq buildQuery() {
        QueryReq.QueryReqBuilder builder = QueryReq.builder().collectionName(StringUtils.isNotBlank((CharSequence)this.collectionAlias) ? this.collectionAlias : this.collectionName);
        String filterStr = this.buildFilters();
        if (StringUtils.isNotBlank((CharSequence)filterStr)) {
            builder.filter(filterStr);
        }
        if (this.topK > 0) {
            builder.limit((long)this.topK);
        }
        if (this.limit > 0L) {
            builder.limit(this.limit);
        }
        if (this.offset > 0L) {
            builder.offset(this.offset);
        }
        if (this.consistencyLevel != null) {
            builder.consistencyLevel(this.consistencyLevel);
        }
        if (!CollectionUtils.isEmpty(this.partitionNames)) {
            builder.partitionNames(this.partitionNames);
        }
        if (this.outputFields != null && !this.outputFields.isEmpty()) {
            builder.outputFields(this.outputFields);
        } else {
            Collection<String> values = this.conversionCache.getPropertyCache().functionToPropertyMap.values();
            builder.outputFields(new ArrayList<String>(values));
        }
        return builder.build();
    }

    private HybridSearchReq buildHybrid() {
        List searchRequests = this.hybridWrapper.stream().filter(v -> StringUtils.isNotEmpty((CharSequence)v.getAnnsField()) && !v.getVectors().isEmpty()).map(v -> {
            Map<String, Object> params;
            String expr;
            AnnSearchReq.AnnSearchReqBuilder annBuilder = AnnSearchReq.builder().vectorFieldName(v.getAnnsField()).vectors(v.getVectors());
            if (v.getTopK() > 0) {
                annBuilder.topK(v.getTopK());
            }
            if (StringUtils.isNotEmpty((CharSequence)(expr = v.buildFilters()))) {
                annBuilder.expr(expr);
            }
            if (!(params = v.searchParams).isEmpty()) {
                annBuilder.params(GsonUtil.toJson(params));
            }
            return annBuilder.build();
        }).collect(Collectors.toList());
        HybridSearchReq.HybridSearchReqBuilder reqBuilder = HybridSearchReq.builder().collectionName(this.collectionName).searchRequests(searchRequests);
        if (this.ranker != null) {
            reqBuilder.ranker(this.ranker);
        }
        if (this.topK > 0) {
            reqBuilder.topK(this.topK);
        }
        if (this.consistencyLevel != null) {
            reqBuilder.consistencyLevel(this.consistencyLevel);
        }
        if (this.outputFields != null && !this.outputFields.isEmpty()) {
            reqBuilder.outFields(this.outputFields);
        } else {
            Collection<String> values = this.conversionCache.getPropertyCache().functionToPropertyMap.values();
            reqBuilder.outFields(new ArrayList<String>(values));
        }
        if (!CollectionUtils.isEmpty(this.partitionNames)) {
            reqBuilder.partitionNames(this.partitionNames);
        }
        if (this.roundDecimal != -1) {
            reqBuilder.roundDecimal(this.roundDecimal);
        }
        HybridSearchReq hybridSearchReq = reqBuilder.build();
        return hybridSearchReq;
    }

    public MilvusResp<List<MilvusResult<T>>> query() throws MilvusException {
        return this.executeWithRetry(() -> {
            if (this.hybridWrapper.size() > 0) {
                HybridSearchReq hybridSearchReq = this.buildHybrid();
                log.info("Build HybridSearch Param--> {}", (Object)GsonUtil.toJson(hybridSearchReq));
                SearchResp searchResp = this.client.hybridSearch(hybridSearchReq);
                return SearchRespConverter.convertSearchRespToMilvusResp(searchResp, this.entityType);
            }
            if (!this.vectors.isEmpty()) {
                SearchReq searchReq = this.buildSearch();
                log.info("Build Search Param--> {}", (Object)GsonUtil.toJson(searchReq));
                SearchResp searchResp = this.client.search(searchReq);
                return SearchRespConverter.convertSearchRespToMilvusResp(searchResp, this.entityType);
            }
            QueryReq queryReq = this.buildQuery();
            log.info("Build Query param--> {}", (Object)GsonUtil.toJson(queryReq));
            QueryResp queryResp = this.client.query(queryReq);
            return SearchRespConverter.convertGetRespToMilvusResp(queryResp, this.entityType);
        }, "collection not loaded", 2, this.entityType, this.client);
    }

    public MilvusResp<List<MilvusResult<T>>> query(FieldFunction<T, ?> ... outputFields) throws MilvusException {
        ArrayList<String> otf = new ArrayList<String>();
        for (FieldFunction<T, ?> outputField : outputFields) {
            otf.add(outputField.getFieldName(outputField));
        }
        this.outputFields = otf;
        return this.query();
    }

    public MilvusResp<Long> count() throws MilvusException {
        this.outputFields = new ArrayList<String>();
        this.outputFields.add("count(*)");
        return this.executeWithRetry(() -> {
            QueryReq queryReq = this.buildQuery();
            log.info("Build Query param--> {}", (Object)GsonUtil.toJson(queryReq));
            QueryResp queryResp = this.client.query(queryReq);
            return SearchRespConverter.convertGetRespToCount(queryResp);
        }, "collection not loaded", 2, this.entityType, this.client);
    }

    public MilvusResp<List<MilvusResult<T>>> query(String ... outputFields) throws MilvusException {
        this.outputFields = Arrays.stream(outputFields).collect(Collectors.toList());
        return this.query();
    }

    public MilvusResp<List<MilvusResult<T>>> getById(Serializable ... ids) {
        GetReq.GetReqBuilder builder = GetReq.builder().collectionName(this.collectionName).ids(Arrays.asList(ids));
        if (!CollectionUtils.isEmpty(this.partitionNames)) {
            builder.partitionName(this.partitionNames.get(0));
        }
        GetReq getReq = builder.build();
        GetResp getResp = this.client.get(getReq);
        return SearchRespConverter.convertGetRespToMilvusResp(getResp, this.entityType);
    }

    @Override
    public void init(String collectionName, MilvusClientV2 client, ConversionCache conversionCache, Class<T> entityType) {
        this.setClient(client);
        this.setCollectionName(collectionName);
        this.setEntityType(entityType);
        this.setConversionCache(conversionCache);
    }

    @Override
    public LambdaQueryWrapper<T> wrapper() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LambdaQueryWrapper)) {
            return false;
        }
        LambdaQueryWrapper other = (LambdaQueryWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getTopK() != other.getTopK()) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        if (this.getRoundDecimal() != other.getRoundDecimal()) {
            return false;
        }
        if (this.getGuaranteeTimestamp() != other.getGuaranteeTimestamp()) {
            return false;
        }
        if (this.isIgnoreGrowing() != other.isIgnoreGrowing()) {
            return false;
        }
        ConversionCache this$conversionCache = this.getConversionCache();
        ConversionCache other$conversionCache = other.getConversionCache();
        if (this$conversionCache == null ? other$conversionCache != null : !((Object)this$conversionCache).equals(other$conversionCache)) {
            return false;
        }
        List<String> this$outputFields = this.getOutputFields();
        List<String> other$outputFields = other.getOutputFields();
        if (this$outputFields == null ? other$outputFields != null : !((Object)this$outputFields).equals(other$outputFields)) {
            return false;
        }
        Class<T> this$entityType = this.getEntityType();
        Class<T> other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        if (this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName)) {
            return false;
        }
        String this$collectionAlias = this.getCollectionAlias();
        String other$collectionAlias = other.getCollectionAlias();
        if (this$collectionAlias == null ? other$collectionAlias != null : !this$collectionAlias.equals(other$collectionAlias)) {
            return false;
        }
        List<String> this$partitionNames = this.getPartitionNames();
        List<String> other$partitionNames = other.getPartitionNames();
        if (this$partitionNames == null ? other$partitionNames != null : !((Object)this$partitionNames).equals(other$partitionNames)) {
            return false;
        }
        String this$annsField = this.getAnnsField();
        String other$annsField = other.getAnnsField();
        if (this$annsField == null ? other$annsField != null : !this$annsField.equals(other$annsField)) {
            return false;
        }
        List<BaseVector> this$vectors = this.getVectors();
        List<BaseVector> other$vectors = other.getVectors();
        if (this$vectors == null ? other$vectors != null : !((Object)this$vectors).equals(other$vectors)) {
            return false;
        }
        ConsistencyLevel this$consistencyLevel = this.getConsistencyLevel();
        ConsistencyLevel other$consistencyLevel = other.getConsistencyLevel();
        if (this$consistencyLevel == null ? other$consistencyLevel != null : !this$consistencyLevel.equals(other$consistencyLevel)) {
            return false;
        }
        MilvusClientV2 this$client = this.getClient();
        MilvusClientV2 other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        Map<String, Object> this$searchParams = this.getSearchParams();
        Map<String, Object> other$searchParams = other.getSearchParams();
        if (this$searchParams == null ? other$searchParams != null : !((Object)this$searchParams).equals(other$searchParams)) {
            return false;
        }
        List<LambdaQueryWrapper<T>> this$hybridWrapper = this.getHybridWrapper();
        List<LambdaQueryWrapper<T>> other$hybridWrapper = other.getHybridWrapper();
        if (this$hybridWrapper == null ? other$hybridWrapper != null : !((Object)this$hybridWrapper).equals(other$hybridWrapper)) {
            return false;
        }
        BaseRanker this$ranker = this.getRanker();
        BaseRanker other$ranker = other.getRanker();
        return !(this$ranker == null ? other$ranker != null : !this$ranker.equals(other$ranker));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LambdaQueryWrapper;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getTopK();
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        long $limit = this.getLimit();
        result = result * 59 + (int)($limit >>> 32 ^ $limit);
        result = result * 59 + this.getRoundDecimal();
        long $guaranteeTimestamp = this.getGuaranteeTimestamp();
        result = result * 59 + (int)($guaranteeTimestamp >>> 32 ^ $guaranteeTimestamp);
        result = result * 59 + (this.isIgnoreGrowing() ? 79 : 97);
        ConversionCache $conversionCache = this.getConversionCache();
        result = result * 59 + ($conversionCache == null ? 43 : ((Object)$conversionCache).hashCode());
        List<String> $outputFields = this.getOutputFields();
        result = result * 59 + ($outputFields == null ? 43 : ((Object)$outputFields).hashCode());
        Class<T> $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        String $collectionAlias = this.getCollectionAlias();
        result = result * 59 + ($collectionAlias == null ? 43 : $collectionAlias.hashCode());
        List<String> $partitionNames = this.getPartitionNames();
        result = result * 59 + ($partitionNames == null ? 43 : ((Object)$partitionNames).hashCode());
        String $annsField = this.getAnnsField();
        result = result * 59 + ($annsField == null ? 43 : $annsField.hashCode());
        List<BaseVector> $vectors = this.getVectors();
        result = result * 59 + ($vectors == null ? 43 : ((Object)$vectors).hashCode());
        ConsistencyLevel $consistencyLevel = this.getConsistencyLevel();
        result = result * 59 + ($consistencyLevel == null ? 43 : $consistencyLevel.hashCode());
        MilvusClientV2 $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        Map<String, Object> $searchParams = this.getSearchParams();
        result = result * 59 + ($searchParams == null ? 43 : ((Object)$searchParams).hashCode());
        List<LambdaQueryWrapper<T>> $hybridWrapper = this.getHybridWrapper();
        result = result * 59 + ($hybridWrapper == null ? 43 : ((Object)$hybridWrapper).hashCode());
        BaseRanker $ranker = this.getRanker();
        result = result * 59 + ($ranker == null ? 43 : $ranker.hashCode());
        return result;
    }

    public ConversionCache getConversionCache() {
        return this.conversionCache;
    }

    public List<String> getOutputFields() {
        return this.outputFields;
    }

    public Class<T> getEntityType() {
        return this.entityType;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getCollectionAlias() {
        return this.collectionAlias;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public String getAnnsField() {
        return this.annsField;
    }

    public int getTopK() {
        return this.topK;
    }

    public List<BaseVector> getVectors() {
        return this.vectors;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    public int getRoundDecimal() {
        return this.roundDecimal;
    }

    public long getGuaranteeTimestamp() {
        return this.guaranteeTimestamp;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public boolean isIgnoreGrowing() {
        return this.ignoreGrowing;
    }

    public MilvusClientV2 getClient() {
        return this.client;
    }

    public Map<String, Object> getSearchParams() {
        return this.searchParams;
    }

    public List<LambdaQueryWrapper<T>> getHybridWrapper() {
        return this.hybridWrapper;
    }

    public BaseRanker getRanker() {
        return this.ranker;
    }

    public void setConversionCache(ConversionCache conversionCache) {
        this.conversionCache = conversionCache;
    }

    public void setOutputFields(List<String> outputFields) {
        this.outputFields = outputFields;
    }

    public void setEntityType(Class<T> entityType) {
        this.entityType = entityType;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setCollectionAlias(String collectionAlias) {
        this.collectionAlias = collectionAlias;
    }

    public void setPartitionNames(List<String> partitionNames) {
        this.partitionNames = partitionNames;
    }

    public void setAnnsField(String annsField) {
        this.annsField = annsField;
    }

    public void setTopK(int topK) {
        this.topK = topK;
    }

    public void setVectors(List<BaseVector> vectors) {
        this.vectors = vectors;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public void setRoundDecimal(int roundDecimal) {
        this.roundDecimal = roundDecimal;
    }

    public void setGuaranteeTimestamp(long guaranteeTimestamp) {
        this.guaranteeTimestamp = guaranteeTimestamp;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public void setIgnoreGrowing(boolean ignoreGrowing) {
        this.ignoreGrowing = ignoreGrowing;
    }

    public void setClient(MilvusClientV2 client) {
        this.client = client;
    }

    public void setSearchParams(Map<String, Object> searchParams) {
        this.searchParams = searchParams;
    }

    public void setHybridWrapper(List<LambdaQueryWrapper<T>> hybridWrapper) {
        this.hybridWrapper = hybridWrapper;
    }

    public void setRanker(BaseRanker ranker) {
        this.ranker = ranker;
    }

    @Override
    public String toString() {
        return "LambdaQueryWrapper(conversionCache=" + this.getConversionCache() + ", outputFields=" + this.getOutputFields() + ", entityType=" + this.getEntityType() + ", collectionName=" + this.getCollectionName() + ", collectionAlias=" + this.getCollectionAlias() + ", partitionNames=" + this.getPartitionNames() + ", annsField=" + this.getAnnsField() + ", topK=" + this.getTopK() + ", vectors=" + this.getVectors() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ", roundDecimal=" + this.getRoundDecimal() + ", guaranteeTimestamp=" + this.getGuaranteeTimestamp() + ", consistencyLevel=" + this.getConsistencyLevel() + ", ignoreGrowing=" + this.isIgnoreGrowing() + ", client=" + this.getClient() + ", searchParams=" + this.getSearchParams() + ", hybridWrapper=" + this.getHybridWrapper() + ", ranker=" + this.getRanker() + ")";
    }
}

