/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.core.conditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.milvus.exception.MilvusException;
import io.milvus.v2.client.MilvusClientV2;
import io.milvus.v2.service.vector.request.QueryReq;
import io.milvus.v2.service.vector.request.UpsertReq;
import io.milvus.v2.service.vector.response.QueryResp;
import io.milvus.v2.service.vector.response.UpsertResp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dromara.milvus.plus.cache.CollectionToPrimaryCache;
import org.dromara.milvus.plus.cache.ConversionCache;
import org.dromara.milvus.plus.cache.PropertyCache;
import org.dromara.milvus.plus.core.FieldFunction;
import org.dromara.milvus.plus.core.conditions.AbstractChainWrapper;
import org.dromara.milvus.plus.core.conditions.ConditionBuilder;
import org.dromara.milvus.plus.core.conditions.Wrapper;
import org.dromara.milvus.plus.model.vo.MilvusResp;
import org.dromara.milvus.plus.util.GsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaUpdateWrapper<T>
extends AbstractChainWrapper<T>
implements Wrapper<LambdaUpdateWrapper<T>, T> {
    private static final Logger log = LoggerFactory.getLogger(LambdaUpdateWrapper.class);
    private ConversionCache conversionCache;
    private Class<T> entityType;
    private String collectionName;
    private String partitionName;
    private MilvusClientV2 client;

    public LambdaUpdateWrapper(String collectionName, MilvusClientV2 client, ConversionCache conversionCache, Class<T> entityType) {
        this.collectionName = collectionName;
        this.client = client;
        this.conversionCache = conversionCache;
        this.entityType = entityType;
    }

    public LambdaUpdateWrapper() {
    }

    public LambdaUpdateWrapper<T> partition(String partitionName) {
        this.partitionName = partitionName;
        return this;
    }

    public LambdaUpdateWrapper<T> partition(FieldFunction<T, ?> partitionName) {
        this.partitionName = partitionName.getFieldName(partitionName);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> eq(String fieldName, Object value) {
        super.eq(fieldName, value);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> ne(String fieldName, Object value) {
        super.ne(fieldName, value);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> gt(String fieldName, Object value) {
        super.gt(fieldName, value);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> ge(String fieldName, Object value) {
        super.ge(fieldName, value);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> lt(String fieldName, Object value) {
        super.lt(fieldName, value);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> le(String fieldName, Object value) {
        super.le(fieldName, value);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> between(String fieldName, Object start, Object end) {
        super.between(fieldName, start, end);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> isNull(String fieldName) {
        super.isNull(fieldName);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> isNotNull(String fieldName) {
        super.isNotNull(fieldName);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> in(String fieldName, List<?> values) {
        super.in(fieldName, values);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> like(String fieldName, String value) {
        super.like(fieldName, value);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> likeLeft(String fieldName, String value) {
        super.likeLeft(fieldName, value);
        return this;
    }

    public LambdaUpdateWrapper<T> likeLeft(boolean condition, String fieldName, String value) {
        if (condition) {
            super.likeLeft(fieldName, value);
        }
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> likeLeft(FieldFunction<T, ?> fieldName, String value) {
        super.likeLeft(fieldName, value);
        return this;
    }

    public LambdaUpdateWrapper<T> likeLeft(boolean condition, FieldFunction<T, ?> fieldName, String value) {
        if (condition) {
            super.likeLeft(fieldName, value);
        }
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> likeRight(String fieldName, String value) {
        super.likeRight(fieldName, value);
        return this;
    }

    public LambdaUpdateWrapper<T> likeRight(boolean condition, String fieldName, String value) {
        if (condition) {
            super.likeRight(fieldName, value);
        }
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> likeRight(FieldFunction<T, ?> fieldName, String value) {
        super.likeRight(fieldName, value);
        return this;
    }

    public LambdaUpdateWrapper<T> likeRight(boolean condition, FieldFunction<T, ?> fieldName, String value) {
        if (condition) {
            super.likeRight(fieldName, value);
        }
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> jsonContains(String fieldName, Object value) {
        super.jsonContains(fieldName, value);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> jsonContainsAll(String fieldName, List<?> values) {
        super.jsonContainsAll(fieldName, values);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> jsonContainsAny(String fieldName, List<?> values) {
        super.jsonContainsAny(fieldName, values);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> arrayContains(String fieldName, Object value) {
        super.arrayContains(fieldName, value);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> arrayContainsAll(String fieldName, List<?> values) {
        super.arrayContainsAll(fieldName, values);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> arrayContainsAny(String fieldName, List<?> values) {
        super.arrayContainsAny(fieldName, values);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> arrayLength(String fieldName, int length) {
        super.arrayLength(fieldName, length);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> eq(FieldFunction<T, ?> fieldName, Object value) {
        super.eq(fieldName, value);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> ne(FieldFunction<T, ?> fieldName, Object value) {
        super.ne(fieldName, value);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> gt(FieldFunction<T, ?> fieldName, Object value) {
        super.gt(fieldName, value);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> ge(FieldFunction<T, ?> fieldName, Object value) {
        super.ge(fieldName, value);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> lt(FieldFunction<T, ?> fieldName, Object value) {
        super.lt(fieldName, value);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> le(FieldFunction<T, ?> fieldName, Object value) {
        super.le(fieldName, value);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> between(FieldFunction<T, ?> fieldName, Object start, Object end) {
        super.between(fieldName, start, end);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> isNull(FieldFunction<T, ?> fieldName) {
        super.isNull(fieldName);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> isNotNull(FieldFunction<T, ?> fieldName) {
        super.isNotNull(fieldName);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> in(FieldFunction<T, ?> fieldName, List<?> values) {
        super.in(fieldName, values);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> like(FieldFunction<T, ?> fieldName, String value) {
        super.like(fieldName, value);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> jsonContains(FieldFunction<T, ?> fieldName, Object value) {
        super.jsonContains(fieldName, value);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> jsonContainsAll(FieldFunction<T, ?> fieldName, List<?> values) {
        super.jsonContainsAll(fieldName, values);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> jsonContainsAny(FieldFunction<T, ?> fieldName, List<?> values) {
        super.jsonContainsAny(fieldName, values);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> arrayContains(FieldFunction<T, ?> fieldName, Object value) {
        super.arrayContains(fieldName, value);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> arrayContainsAll(FieldFunction<T, ?> fieldName, List<?> values) {
        super.arrayContainsAll(fieldName, values);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> arrayContainsAny(FieldFunction<T, ?> fieldName, List<?> values) {
        super.arrayContainsAny(fieldName, values);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> arrayLength(FieldFunction<T, ?> fieldName, int length) {
        super.arrayLength(fieldName, length);
        return this;
    }

    public LambdaUpdateWrapper<T> eq(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.eq(fieldName, value);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> ne(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.ne(fieldName, value);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> gt(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.gt(fieldName, value);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> ge(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.ge(fieldName, value);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> lt(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.lt(fieldName, value);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> le(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.le(fieldName, value);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> between(boolean condition, String fieldName, Object start, Object end) {
        if (condition) {
            super.between(fieldName, start, end);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> in(boolean condition, String fieldName, List<?> values) {
        if (condition) {
            super.in(fieldName, values);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> like(boolean condition, String fieldName, String value) {
        if (condition) {
            super.like(fieldName, value);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> jsonContains(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.jsonContains(fieldName, value);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> jsonContainsAll(boolean condition, String fieldName, List<?> values) {
        if (condition) {
            super.jsonContainsAll(fieldName, values);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> jsonContainsAny(boolean condition, String fieldName, List<?> values) {
        if (condition) {
            super.jsonContainsAny(fieldName, values);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> arrayContains(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.arrayContains(fieldName, value);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> arrayContainsAll(boolean condition, String fieldName, List<?> values) {
        if (condition) {
            super.arrayContainsAll(fieldName, values);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> arrayContainsAny(boolean condition, String fieldName, List<?> values) {
        if (condition) {
            super.arrayContainsAny(fieldName, values);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> arrayLength(boolean condition, String fieldName, int length) {
        if (condition) {
            super.arrayLength(fieldName, length);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> eq(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.eq(fieldName, value);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> ne(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.ne(fieldName, value);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> gt(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.gt(fieldName, value);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> ge(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.ge(fieldName, value);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> lt(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.lt(fieldName, value);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> le(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.le(fieldName, value);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> between(boolean condition, FieldFunction<T, ?> fieldName, Object start, Object end) {
        if (condition) {
            super.between(fieldName, start, end);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> in(boolean condition, FieldFunction<T, ?> fieldName, List<?> values) {
        if (condition) {
            super.in(fieldName, values);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> like(boolean condition, FieldFunction<T, ?> fieldName, String value) {
        if (condition) {
            super.like(fieldName, value);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> jsonContains(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.jsonContains(fieldName, value);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> jsonContainsAll(boolean condition, FieldFunction<T, ?> fieldName, List<?> values) {
        if (condition) {
            super.jsonContainsAll(fieldName, values);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> jsonContainsAny(boolean condition, FieldFunction<T, ?> fieldName, List<?> values) {
        if (condition) {
            super.jsonContainsAny(fieldName, values);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> arrayContains(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.arrayContains(fieldName, value);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> arrayContainsAll(boolean condition, FieldFunction<T, ?> fieldName, List<?> values) {
        if (condition) {
            super.arrayContainsAll(fieldName, values);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> arrayContainsAny(boolean condition, FieldFunction<T, ?> fieldName, List<?> values) {
        if (condition) {
            super.arrayContainsAny(fieldName, values);
        }
        return this;
    }

    public LambdaUpdateWrapper<T> arrayLength(boolean condition, FieldFunction<T, ?> fieldName, int length) {
        if (condition) {
            super.arrayLength(fieldName, length);
        }
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> and(ConditionBuilder<T> other) {
        super.and(other);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> or(ConditionBuilder<T> other) {
        super.or(other);
        return this;
    }

    @Override
    public LambdaUpdateWrapper<T> not() {
        super.not();
        return this;
    }

    private QueryResp build() {
        String filterStr = this.buildFilters();
        if (filterStr != null && !filterStr.isEmpty()) {
            QueryReq.QueryReqBuilder builder = QueryReq.builder().collectionName(this.collectionName).filter(filterStr);
            return this.client.query(builder.build());
        }
        return null;
    }

    public MilvusResp<UpsertResp> update(T entity) throws MilvusException {
        boolean needBuildQuery;
        String primaryKeyField = CollectionToPrimaryCache.collectionToPrimary.get(this.collectionName);
        Map<String, Object> propertiesMap = this.getPropertiesMap(entity);
        PropertyCache propertyCache = this.conversionCache.getPropertyCache();
        boolean hasPrimaryKey = false;
        Object primaryKeyValue = null;
        ArrayList<JsonObject> updateDataList = new ArrayList<JsonObject>();
        JsonObject updateObject = new JsonObject();
        for (Map.Entry<String, Object> entry : propertiesMap.entrySet()) {
            String string = entry.getKey();
            Object value = entry.getValue();
            String tableNameColumn = propertyCache.functionToPropertyMap.get(string);
            if (primaryKeyField.equals(tableNameColumn)) {
                hasPrimaryKey = true;
                primaryKeyValue = value;
            }
            GsonUtil.put(updateObject, tableNameColumn, value);
        }
        boolean bl = needBuildQuery = !hasPrimaryKey;
        if (hasPrimaryKey) {
            for (Map.Entry<String, String> entry : propertyCache.functionToPropertyMap.entrySet()) {
                if (updateObject.get(entry.getValue()) != null) continue;
                needBuildQuery = true;
                this.eq(primaryKeyField, primaryKeyValue);
                break;
            }
        }
        if (needBuildQuery) {
            QueryResp queryResp = this.build();
            if (queryResp != null) {
                for (QueryResp.QueryResult result : queryResp.getQueryResults()) {
                    Map existingEntity = result.getEntity();
                    JsonObject existingData = new JsonObject();
                    for (Map.Entry existingEntry : existingEntity.entrySet()) {
                        String existingField = (String)existingEntry.getKey();
                        Object existingValue = existingEntry.getValue();
                        JsonElement updateValue = updateObject.get(existingField);
                        GsonUtil.put(existingData, existingField, updateValue != null ? updateValue : existingValue);
                    }
                    updateDataList.add(existingData);
                }
            }
        } else {
            updateDataList.add(updateObject);
        }
        if (updateDataList.isEmpty()) {
            return new MilvusResp<UpsertResp>();
        }
        return this.update((List<JsonObject>)updateDataList);
    }

    private MilvusResp<UpsertResp> update(List<JsonObject> jsonObjects) {
        return this.executeWithRetry(() -> {
            log.info("update data--->{}", (Object)GsonUtil.toJson(jsonObjects));
            UpsertReq.UpsertReqBuilder builder = UpsertReq.builder().collectionName(this.collectionName).data(jsonObjects);
            if (StringUtils.isNotEmpty((CharSequence)this.partitionName)) {
                builder.partitionName(this.partitionName);
            }
            UpsertReq upsertReq = builder.build();
            UpsertResp upsert = this.client.upsert(upsertReq);
            MilvusResp<UpsertResp> resp = new MilvusResp<UpsertResp>();
            resp.setData(upsert);
            resp.setSuccess(true);
            return resp;
        }, "collection not loaded", 2, this.entityType, this.client);
    }

    public MilvusResp<UpsertResp> updateById(T ... entity) throws MilvusException {
        AbstractChainWrapper.ArrayIterator<T> iterator = new AbstractChainWrapper.ArrayIterator<T>(entity);
        return this.updateById(iterator);
    }

    public MilvusResp<UpsertResp> updateById(Iterator<T> iterator) throws MilvusException {
        PropertyCache propertyCache = this.conversionCache.getPropertyCache();
        String pk = CollectionToPrimaryCache.collectionToPrimary.get(this.collectionName);
        ArrayList<JsonObject> jsonObjects = new ArrayList<JsonObject>();
        while (iterator.hasNext()) {
            T t1 = iterator.next();
            Map<String, Object> propertiesMap = this.getPropertiesMap(t1);
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry<String, Object> entry : propertiesMap.entrySet()) {
                String string = entry.getKey();
                Object value = entry.getValue();
                String tk = propertyCache.functionToPropertyMap.get(string);
                GsonUtil.put(jsonObject, tk, value);
            }
            if (!jsonObject.has(pk)) {
                throw new MilvusException("not find primary key", Integer.valueOf(400));
            }
            jsonObjects.add(jsonObject);
        }
        ArrayList<JsonObject> updateDataList = new ArrayList<JsonObject>();
        for (JsonObject updateObject : jsonObjects) {
            boolean isBuild = false;
            for (Map.Entry<String, String> entry : propertyCache.functionToPropertyMap.entrySet()) {
                if (updateObject.get(entry.getValue()) != null) continue;
                isBuild = true;
            }
            if (isBuild) {
                QueryReq.QueryReqBuilder queryReqBuilder = QueryReq.builder().collectionName(this.collectionName).filter(pk + " == " + updateObject.get(pk));
                QueryResp queryResp = this.client.query(queryReqBuilder.build());
                if (queryResp == null) continue;
                for (QueryResp.QueryResult result : queryResp.getQueryResults()) {
                    Map existingEntity = result.getEntity();
                    JsonObject existingData = new JsonObject();
                    for (Map.Entry existingEntry : existingEntity.entrySet()) {
                        String existingField = (String)existingEntry.getKey();
                        Object existingValue = existingEntry.getValue();
                        JsonElement updateValue = updateObject.get(existingField);
                        GsonUtil.put(existingData, existingField, updateValue != null ? updateValue : existingValue);
                    }
                    updateDataList.add(existingData);
                }
                continue;
            }
            updateDataList.add(updateObject);
        }
        return this.update((List<JsonObject>)updateDataList);
    }

    @Override
    public void init(String collectionName, MilvusClientV2 client, ConversionCache conversionCache, Class<T> entityType) {
        this.setClient(client);
        this.setCollectionName(collectionName);
        this.setEntityType(entityType);
        this.setConversionCache(conversionCache);
    }

    @Override
    public LambdaUpdateWrapper<T> wrapper() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LambdaUpdateWrapper)) {
            return false;
        }
        LambdaUpdateWrapper other = (LambdaUpdateWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConversionCache this$conversionCache = this.getConversionCache();
        ConversionCache other$conversionCache = other.getConversionCache();
        if (this$conversionCache == null ? other$conversionCache != null : !((Object)this$conversionCache).equals(other$conversionCache)) {
            return false;
        }
        Class<T> this$entityType = this.getEntityType();
        Class<T> other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        if (this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName)) {
            return false;
        }
        String this$partitionName = this.getPartitionName();
        String other$partitionName = other.getPartitionName();
        if (this$partitionName == null ? other$partitionName != null : !this$partitionName.equals(other$partitionName)) {
            return false;
        }
        MilvusClientV2 this$client = this.getClient();
        MilvusClientV2 other$client = other.getClient();
        return !(this$client == null ? other$client != null : !this$client.equals(other$client));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LambdaUpdateWrapper;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ConversionCache $conversionCache = this.getConversionCache();
        result = result * 59 + ($conversionCache == null ? 43 : ((Object)$conversionCache).hashCode());
        Class<T> $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        String $partitionName = this.getPartitionName();
        result = result * 59 + ($partitionName == null ? 43 : $partitionName.hashCode());
        MilvusClientV2 $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        return result;
    }

    public ConversionCache getConversionCache() {
        return this.conversionCache;
    }

    public Class<T> getEntityType() {
        return this.entityType;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public MilvusClientV2 getClient() {
        return this.client;
    }

    public void setConversionCache(ConversionCache conversionCache) {
        this.conversionCache = conversionCache;
    }

    public void setEntityType(Class<T> entityType) {
        this.entityType = entityType;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    public void setClient(MilvusClientV2 client) {
        this.client = client;
    }

    @Override
    public String toString() {
        return "LambdaUpdateWrapper(conversionCache=" + this.getConversionCache() + ", entityType=" + this.getEntityType() + ", collectionName=" + this.getCollectionName() + ", partitionName=" + this.getPartitionName() + ", client=" + this.getClient() + ")";
    }
}

