/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.service;

import io.milvus.exception.MilvusException;
import io.milvus.v2.client.MilvusClientV2;
import io.milvus.v2.common.IndexParam;
import io.milvus.v2.service.collection.request.AddFieldReq;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.service.collection.request.DescribeCollectionReq;
import io.milvus.v2.service.collection.request.DropCollectionReq;
import io.milvus.v2.service.collection.request.GetCollectionStatsReq;
import io.milvus.v2.service.collection.request.GetLoadStateReq;
import io.milvus.v2.service.collection.request.HasCollectionReq;
import io.milvus.v2.service.collection.request.LoadCollectionReq;
import io.milvus.v2.service.collection.request.ReleaseCollectionReq;
import io.milvus.v2.service.collection.request.RenameCollectionReq;
import io.milvus.v2.service.collection.response.DescribeCollectionResp;
import io.milvus.v2.service.collection.response.GetCollectionStatsResp;
import io.milvus.v2.service.index.request.CreateIndexReq;
import io.milvus.v2.service.index.request.DescribeIndexReq;
import io.milvus.v2.service.index.request.DropIndexReq;
import io.milvus.v2.service.index.response.DescribeIndexResp;
import io.milvus.v2.service.partition.request.CreatePartitionReq;
import io.milvus.v2.service.partition.request.DropPartitionReq;
import io.milvus.v2.service.partition.request.HasPartitionReq;
import io.milvus.v2.service.partition.request.ListPartitionsReq;
import io.milvus.v2.service.partition.request.LoadPartitionsReq;
import io.milvus.v2.service.partition.request.ReleasePartitionsReq;
import io.milvus.v2.service.utility.request.AlterAliasReq;
import io.milvus.v2.service.utility.request.CreateAliasReq;
import io.milvus.v2.service.utility.request.DropAliasReq;
import io.milvus.v2.service.utility.request.ListAliasesReq;
import io.milvus.v2.service.utility.response.ListAliasResp;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dromara.milvus.plus.builder.CollectionSchemaBuilder;
import org.dromara.milvus.plus.converter.MilvusConverter;
import org.dromara.milvus.plus.core.FieldFunction;
import org.dromara.milvus.plus.model.MilvusEntity;

public interface ICMService {
    public MilvusClientV2 getClient();

    default public void createCollection(Class<?> milvusClass) {
        MilvusEntity milvusEntity = MilvusConverter.convert(milvusClass);
        this.createCollection(milvusEntity);
    }

    default public void createCollection(MilvusEntity milvusEntity) {
        MilvusClientV2 client = this.getClient();
        try {
            String collectionName = milvusEntity.getCollectionName();
            boolean collectionExists = client.hasCollection(HasCollectionReq.builder().collectionName(collectionName).build());
            if (!collectionExists) {
                MilvusConverter.create(milvusEntity, client);
            }
            MilvusConverter.loadStatus(milvusEntity, client);
        }
        catch (MilvusException e) {
            throw new RuntimeException("Error handling Milvus collection", e);
        }
    }

    default public void addField(String collectionName, AddFieldReq ... addFieldReq) {
        MilvusClientV2 client = this.getClient();
        CollectionSchemaBuilder schemaBuilder = new CollectionSchemaBuilder(collectionName, client);
        for (AddFieldReq fieldReq : addFieldReq) {
            schemaBuilder.addField(fieldReq);
        }
    }

    default public CreateCollectionReq.FieldSchema getField(String collectionName, String fieldName) {
        MilvusClientV2 client = this.getClient();
        CollectionSchemaBuilder schemaBuilder = new CollectionSchemaBuilder(collectionName, client);
        return schemaBuilder.getField(fieldName);
    }

    default public CreateCollectionReq.FieldSchema getField(FieldFunction collectionName, FieldFunction fieldName) {
        String fieldName1 = fieldName.getFieldName(fieldName);
        String collectionName1 = collectionName.getFieldName(collectionName);
        return this.getField(collectionName1, fieldName1);
    }

    default public DescribeCollectionResp describeCollection(String collectionName) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        DescribeCollectionReq describeCollectionReq = DescribeCollectionReq.builder().collectionName(collectionName).build();
        return client.describeCollection(describeCollectionReq);
    }

    default public void dropCollection(String collectionName) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        DropCollectionReq dropCollectionReq = DropCollectionReq.builder().collectionName(collectionName).build();
        client.dropCollection(dropCollectionReq);
        boolean isDropped = this.hasCollection(collectionName);
        if (!isDropped) {
            throw new RuntimeException("Failed to drop collection: " + collectionName);
        }
    }

    default public boolean hasCollection(String collectionName) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        boolean hasCollection = client.hasCollection(HasCollectionReq.builder().collectionName(collectionName).build());
        return hasCollection;
    }

    default public GetCollectionStatsResp getCollectionStats(String collectionName) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        GetCollectionStatsReq getCollectionStatsReq = GetCollectionStatsReq.builder().collectionName(collectionName).build();
        return client.getCollectionStats(getCollectionStatsReq);
    }

    default public void renameCollection(String oldCollectionName, String newCollectionName) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        RenameCollectionReq renameCollectionReq = RenameCollectionReq.builder().collectionName(oldCollectionName).newCollectionName(newCollectionName).build();
        client.renameCollection(renameCollectionReq);
    }

    default public void createIndex(String collectionName, List<IndexParam> indexParams) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        CreateIndexReq createIndexReq = CreateIndexReq.builder().collectionName(collectionName).indexParams(indexParams).build();
        client.createIndex(createIndexReq);
    }

    default public void createIndex(String collectionName, String fieldName, IndexParam.MetricType metricType, IndexParam.IndexType indexType) throws MilvusException {
        IndexParam indexParam = IndexParam.builder().metricType(metricType).indexType(indexType).fieldName(fieldName).build();
        this.createIndex(collectionName, Collections.singletonList(indexParam));
    }

    default public DescribeIndexResp describeIndex(String collectionName, String fieldName) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        DescribeIndexReq describeIndexReq = DescribeIndexReq.builder().collectionName(collectionName).fieldName(fieldName).build();
        return client.describeIndex(describeIndexReq);
    }

    default public DescribeIndexResp describeIndex(String collectionName, FieldFunction fieldName) throws MilvusException {
        return this.describeIndex(collectionName, fieldName.getFieldName(fieldName));
    }

    default public void dropIndex(String collectionName, String fieldName) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        DropIndexReq dropIndexReq = DropIndexReq.builder().collectionName(collectionName).fieldName(fieldName).build();
        client.dropIndex(dropIndexReq);
    }

    default public Boolean getLoadState(String collectionName, String partitionName) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        GetLoadStateReq.GetLoadStateReqBuilder builder = GetLoadStateReq.builder().collectionName(collectionName);
        if (StringUtils.isNotEmpty((CharSequence)partitionName)) {
            builder.partitionName(partitionName);
        }
        GetLoadStateReq getLoadStateReq = builder.build();
        return client.getLoadState(getLoadStateReq);
    }

    default public Boolean isCollectionLoaded(String collectionName) throws MilvusException {
        return this.getLoadState(collectionName, null);
    }

    default public void loadCollection(String collectionName, Integer numReplicas, Boolean async, Long timeout) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        LoadCollectionReq loadCollectionReq = LoadCollectionReq.builder().collectionName(collectionName).numReplicas(numReplicas).async(async).timeout(timeout).build();
        client.loadCollection(loadCollectionReq);
    }

    default public void loadCollection(String collectionName) throws MilvusException {
        this.loadCollection(collectionName, 1, true, 60000L);
    }

    default public void releaseCollection(String collectionName, Boolean async, Long timeout) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        ReleaseCollectionReq releaseCollectionReq = ReleaseCollectionReq.builder().collectionName(collectionName).async(async).timeout(timeout).build();
        client.releaseCollection(releaseCollectionReq);
    }

    default public void releaseCollection(String collectionName) throws MilvusException {
        this.releaseCollection(collectionName, true, 60000L);
    }

    default public void createPartition(String collectionName, String partitionName) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        CreatePartitionReq createPartitionReq = CreatePartitionReq.builder().collectionName(collectionName).partitionName(partitionName).build();
        client.createPartition(createPartitionReq);
    }

    default public void dropPartition(String collectionName, String partitionName) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        DropPartitionReq dropPartitionReq = DropPartitionReq.builder().collectionName(collectionName).partitionName(partitionName).build();
        client.dropPartition(dropPartitionReq);
    }

    default public Boolean hasPartition(String collectionName, String partitionName) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        HasPartitionReq hasPartitionReq = HasPartitionReq.builder().collectionName(collectionName).partitionName(partitionName).build();
        return client.hasPartition(hasPartitionReq);
    }

    default public List<String> listPartitions(String collectionName) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        ListPartitionsReq listPartitionsReq = ListPartitionsReq.builder().collectionName(collectionName).build();
        return client.listPartitions(listPartitionsReq);
    }

    default public void loadPartitions(String collectionName, List<String> partitionNames) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        LoadPartitionsReq loadPartitionsReq = LoadPartitionsReq.builder().collectionName(collectionName).partitionNames(partitionNames).build();
        client.loadPartitions(loadPartitionsReq);
    }

    default public void loadPartition(String collectionName, String partitionName) throws MilvusException {
        this.loadPartitions(collectionName, Collections.singletonList(partitionName));
    }

    default public void releasePartitions(String collectionName, List<String> partitionNames) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        ReleasePartitionsReq releasePartitionsReq = ReleasePartitionsReq.builder().collectionName(collectionName).partitionNames(partitionNames).build();
        client.releasePartitions(releasePartitionsReq);
    }

    default public void releasePartition(String collectionName, String partitionName) throws MilvusException {
        this.releasePartitions(collectionName, Collections.singletonList(partitionName));
    }

    default public void createAlias(MilvusEntity milvusEntity) {
        MilvusClientV2 client = this.getClient();
        for (String alias : milvusEntity.getAlias()) {
            CreateAliasReq createAliasReq = CreateAliasReq.builder().alias(alias).collectionName(milvusEntity.getCollectionName()).build();
            client.createAlias(createAliasReq);
        }
    }

    default public void createAlias(Class<?> milvusClass) {
        MilvusEntity milvusEntity = MilvusConverter.convert(milvusClass);
        this.createAlias(milvusEntity);
    }

    default public void dropAlias(MilvusEntity milvusEntity) {
        MilvusClientV2 client = this.getClient();
        for (String alias : milvusEntity.getAlias()) {
            client.dropAlias(DropAliasReq.builder().alias(alias).build());
        }
    }

    default public void alterAlias(MilvusEntity milvusEntity) {
        MilvusClientV2 client = this.getClient();
        for (String alias : milvusEntity.getAlias()) {
            client.alterAlias(AlterAliasReq.builder().collectionName(milvusEntity.getCollectionName()).alias(alias).build());
        }
    }

    default public ListAliasResp listAliases(MilvusEntity milvusEntity) {
        MilvusClientV2 client = this.getClient();
        return client.listAliases(ListAliasesReq.builder().collectionName(milvusEntity.getCollectionName()).build());
    }
}

