/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.core.conditions;

import io.milvus.v2.client.MilvusClientV2;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.dromara.milvus.plus.cache.ConversionCache;
import org.dromara.milvus.plus.cache.MilvusCache;
import org.dromara.milvus.plus.converter.MilvusConverter;
import org.dromara.milvus.plus.core.conditions.ConditionBuilder;
import org.dromara.milvus.plus.model.vo.MilvusResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChainWrapper<T>
extends ConditionBuilder<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractChainWrapper.class);
    public static final int maxRetries = 2;

    protected <R> MilvusResp<R> executeWithRetry(Supplier<MilvusResp<R>> action, String errorMessage, int maxRetries, Class entityType, MilvusClientV2 client) {
        int attempt = 1;
        while (true) {
            try {
                return action.get();
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().contains(errorMessage) && attempt < maxRetries) {
                    log.warn("Attempt {}: {} - attempting to retry.", (Object)attempt, (Object)errorMessage);
                    this.handleCollectionNotLoaded(entityType, client);
                    ++attempt;
                    continue;
                }
                throw new RuntimeException(e);
            }
            break;
        }
    }

    protected void handleCollectionNotLoaded(Class entityType, MilvusClientV2 client) {
        ConversionCache cache = MilvusCache.milvusCache.get(entityType.getName());
        MilvusConverter.loadStatus(cache.getMilvusEntity(), client);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractChainWrapper)) {
            return false;
        }
        AbstractChainWrapper other = (AbstractChainWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractChainWrapper;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public String toString() {
        return "AbstractChainWrapper()";
    }

    protected static class ArrayIterator<T>
    implements Iterator<T> {
        private final T[] array;
        private int index = 0;

        public ArrayIterator(T[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.array.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.index++];
        }
    }
}

