/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.service;

import io.milvus.v2.client.MilvusClientV2;
import io.milvus.v2.service.rbac.request.CreateRoleReq;
import io.milvus.v2.service.rbac.request.CreateUserReq;
import io.milvus.v2.service.rbac.request.DescribeRoleReq;
import io.milvus.v2.service.rbac.request.DescribeUserReq;
import io.milvus.v2.service.rbac.request.DropRoleReq;
import io.milvus.v2.service.rbac.request.DropUserReq;
import io.milvus.v2.service.rbac.request.GrantPrivilegeReq;
import io.milvus.v2.service.rbac.request.GrantRoleReq;
import io.milvus.v2.service.rbac.request.RevokePrivilegeReq;
import io.milvus.v2.service.rbac.request.RevokeRoleReq;
import io.milvus.v2.service.rbac.request.UpdatePasswordReq;
import io.milvus.v2.service.rbac.response.DescribeRoleResp;
import io.milvus.v2.service.rbac.response.DescribeUserResp;
import java.util.List;

public interface IAMService {
    public MilvusClientV2 getClient();

    default public void createRole(String roleName) {
        MilvusClientV2 client = this.getClient();
        client.createRole(CreateRoleReq.builder().roleName(roleName).build());
    }

    default public void createUser(String userName, String password) {
        MilvusClientV2 client = this.getClient();
        client.createUser(CreateUserReq.builder().userName(userName).password(password).build());
    }

    default public DescribeRoleResp describeRole(String roleName) {
        MilvusClientV2 client = this.getClient();
        DescribeRoleResp describeRoleResp = client.describeRole(DescribeRoleReq.builder().roleName(roleName).build());
        return describeRoleResp;
    }

    default public DescribeUserResp describeUser(String userName) {
        MilvusClientV2 client = this.getClient();
        DescribeUserResp describeUserResp = client.describeUser(DescribeUserReq.builder().userName(userName).build());
        return describeUserResp;
    }

    default public void dropRole(String roleName) {
        MilvusClientV2 client = this.getClient();
        client.dropRole(DropRoleReq.builder().roleName(roleName).build());
    }

    default public void dropUser(String userName) {
        MilvusClientV2 client = this.getClient();
        client.dropUser(DropUserReq.builder().userName(userName).build());
    }

    default public void grantPrivilege(String roleName, String objectType, String privilege, String objectName) {
        MilvusClientV2 client = this.getClient();
        client.grantPrivilege(GrantPrivilegeReq.builder().roleName(roleName).objectType(objectType).privilege(privilege).objectName(objectName).build());
    }

    default public void grantRole(String roleName, String userName) {
        MilvusClientV2 client = this.getClient();
        client.grantRole(GrantRoleReq.builder().roleName(roleName).userName(userName).build());
    }

    default public List<String> listRoles() {
        MilvusClientV2 client = this.getClient();
        return client.listRoles();
    }

    default public List<String> listUsers() {
        MilvusClientV2 client = this.getClient();
        return client.listUsers();
    }

    default public void revokePrivilege(String roleName, String objectType, String privilege, String objectName, String databaseName) {
        MilvusClientV2 client = this.getClient();
        client.revokePrivilege(RevokePrivilegeReq.builder().roleName(roleName).objectType(objectType).privilege(privilege).objectName(objectName).dbName(databaseName).build());
    }

    default public void revokeRole(String roleName, String userName) {
        MilvusClientV2 client = this.getClient();
        client.revokeRole(RevokeRoleReq.builder().roleName(roleName).userName(userName).build());
    }

    default public void updatePassword(String userName, String password, String newPassword) {
        MilvusClientV2 client = this.getClient();
        client.updatePassword(UpdatePasswordReq.builder().userName(userName).password(password).newPassword(newPassword).build());
    }
}

