/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.converter;

import io.milvus.v2.service.vector.response.GetResp;
import io.milvus.v2.service.vector.response.QueryResp;
import io.milvus.v2.service.vector.response.SearchResp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.dromara.milvus.plus.cache.ConversionCache;
import org.dromara.milvus.plus.cache.MilvusCache;
import org.dromara.milvus.plus.cache.PropertyCache;
import org.dromara.milvus.plus.model.vo.MilvusResp;
import org.dromara.milvus.plus.model.vo.MilvusResult;
import org.dromara.milvus.plus.util.GsonUtil;

public class SearchRespConverter {
    public static <T> MilvusResp<List<MilvusResult<T>>> convertSearchRespToMilvusResp(SearchResp searchResp, Class<T> entityType) {
        ConversionCache conversionCache = MilvusCache.milvusCache.get(entityType.getName());
        PropertyCache propertyCache = conversionCache.getPropertyCache();
        List results = Optional.ofNullable(searchResp.getSearchResults()).orElseGet(ArrayList::new).parallelStream().flatMap(Collection::stream).map(searchResult -> {
            HashMap<String, Object> entityMap = new HashMap<String, Object>();
            for (Map.Entry entry : searchResult.getEntity().entrySet()) {
                String key = propertyCache.findKeyByValue((String)entry.getKey());
                if (key == null) continue;
                Object value = entry.getValue();
                entityMap.put(key, value);
            }
            Object entity = GsonUtil.convertMapToType(entityMap, entityType);
            MilvusResult tMilvusResult = new MilvusResult();
            tMilvusResult.setId(searchResult.getId());
            tMilvusResult.setDistance(searchResult.getScore());
            tMilvusResult.setEntity(entity);
            return tMilvusResult;
        }).collect(Collectors.toList());
        MilvusResp milvusResp = new MilvusResp();
        milvusResp.setData(results);
        milvusResp.setSuccess(true);
        return milvusResp;
    }

    public static <T> MilvusResp<List<MilvusResult<T>>> convertGetRespToMilvusResp(QueryResp getResp, Class<T> entityType) {
        List queryResults = getResp.getQueryResults();
        return SearchRespConverter.convertQuery(queryResults, entityType);
    }

    public static MilvusResp<Long> convertGetRespToCount(QueryResp getResp) {
        List queryResults = getResp.getQueryResults();
        return SearchRespConverter.convertQueryCount(queryResults);
    }

    public static <T> MilvusResp<List<MilvusResult<T>>> convertGetRespToMilvusResp(GetResp getResp, Class<T> entityType) {
        List getResults = getResp.getResults;
        return SearchRespConverter.convertQuery(getResults, entityType);
    }

    private static <T> MilvusResp<List<MilvusResult<T>>> convertQuery(List<QueryResp.QueryResult> getResults, Class<T> entityType) {
        ConversionCache conversionCache = MilvusCache.milvusCache.get(entityType.getName());
        PropertyCache propertyCache = conversionCache.getPropertyCache();
        ArrayList entities = new ArrayList();
        for (QueryResp.QueryResult queryResult : getResults) {
            Map entityMap = queryResult.getEntity();
            HashMap<String, Object> entityMap2 = new HashMap<String, Object>();
            for (Map.Entry entry : entityMap.entrySet()) {
                String key = propertyCache.findKeyByValue((String)entry.getKey());
                if (key == null) continue;
                Object value = entry.getValue();
                entityMap2.put(key, value);
            }
            Object entity = GsonUtil.convertMapToType(entityMap2, entityType);
            entities.add(entity);
        }
        List results = entities.stream().map(v -> {
            MilvusResult<Object> vo = new MilvusResult<Object>();
            vo.setEntity(v);
            vo.setDistance(Float.valueOf(0.0f));
            return vo;
        }).collect(Collectors.toList());
        MilvusResp milvusResp = new MilvusResp();
        milvusResp.setData(results);
        milvusResp.setSuccess(true);
        return milvusResp;
    }

    private static MilvusResp<Long> convertQueryCount(List<QueryResp.QueryResult> getResults) {
        Long total = 0L;
        for (QueryResp.QueryResult queryResult : getResults) {
            Map entityMap = queryResult.getEntity();
            total = (Long)entityMap.get("count(*)");
        }
        MilvusResp<Long> milvusResp = new MilvusResp<Long>();
        milvusResp.setData(total);
        milvusResp.setSuccess(true);
        return milvusResp;
    }
}

