/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.model;

import io.milvus.v2.common.DataType;
import io.milvus.v2.service.collection.request.AddFieldReq;
import org.apache.commons.lang3.StringUtils;

public class MilvusField {
    private String fieldName;
    private DataType dataType;
    private Boolean isPrimaryKey;
    private Boolean autoId;
    private String description;
    private Integer dimension;
    private Integer maxLength;
    private Boolean isPartitionKey;
    private DataType elementType;
    private Integer maxCapacity;

    public AddFieldReq to() {
        return AddFieldReq.builder().fieldName(this.fieldName).dataType(this.dataType).isPrimaryKey(this.isPrimaryKey).autoID(this.autoId).description(StringUtils.isNotEmpty((CharSequence)this.description) ? this.description : null).dimension(this.dimension).maxLength(this.maxLength != null && this.maxLength > 0 ? this.maxLength : null).isPartitionKey(this.isPartitionKey).elementType(this.elementType).maxCapacity(this.maxCapacity != null && this.maxCapacity > 0 ? this.maxCapacity : null).build();
    }

    public static MilvusFieldBuilder builder() {
        return new MilvusFieldBuilder();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Boolean getIsPrimaryKey() {
        return this.isPrimaryKey;
    }

    public Boolean getAutoId() {
        return this.autoId;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getDimension() {
        return this.dimension;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Boolean getIsPartitionKey() {
        return this.isPartitionKey;
    }

    public DataType getElementType() {
        return this.elementType;
    }

    public Integer getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public void setIsPrimaryKey(Boolean isPrimaryKey) {
        this.isPrimaryKey = isPrimaryKey;
    }

    public void setAutoId(Boolean autoId) {
        this.autoId = autoId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setIsPartitionKey(Boolean isPartitionKey) {
        this.isPartitionKey = isPartitionKey;
    }

    public void setElementType(DataType elementType) {
        this.elementType = elementType;
    }

    public void setMaxCapacity(Integer maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MilvusField)) {
            return false;
        }
        MilvusField other = (MilvusField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isPrimaryKey = this.getIsPrimaryKey();
        Boolean other$isPrimaryKey = other.getIsPrimaryKey();
        if (this$isPrimaryKey == null ? other$isPrimaryKey != null : !((Object)this$isPrimaryKey).equals(other$isPrimaryKey)) {
            return false;
        }
        Boolean this$autoId = this.getAutoId();
        Boolean other$autoId = other.getAutoId();
        if (this$autoId == null ? other$autoId != null : !((Object)this$autoId).equals(other$autoId)) {
            return false;
        }
        Integer this$dimension = this.getDimension();
        Integer other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !((Object)this$dimension).equals(other$dimension)) {
            return false;
        }
        Integer this$maxLength = this.getMaxLength();
        Integer other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        Boolean this$isPartitionKey = this.getIsPartitionKey();
        Boolean other$isPartitionKey = other.getIsPartitionKey();
        if (this$isPartitionKey == null ? other$isPartitionKey != null : !((Object)this$isPartitionKey).equals(other$isPartitionKey)) {
            return false;
        }
        Integer this$maxCapacity = this.getMaxCapacity();
        Integer other$maxCapacity = other.getMaxCapacity();
        if (this$maxCapacity == null ? other$maxCapacity != null : !((Object)this$maxCapacity).equals(other$maxCapacity)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        DataType this$dataType = this.getDataType();
        DataType other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        DataType this$elementType = this.getElementType();
        DataType other$elementType = other.getElementType();
        return !(this$elementType == null ? other$elementType != null : !this$elementType.equals(other$elementType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MilvusField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isPrimaryKey = this.getIsPrimaryKey();
        result = result * 59 + ($isPrimaryKey == null ? 43 : ((Object)$isPrimaryKey).hashCode());
        Boolean $autoId = this.getAutoId();
        result = result * 59 + ($autoId == null ? 43 : ((Object)$autoId).hashCode());
        Integer $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : ((Object)$dimension).hashCode());
        Integer $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        Boolean $isPartitionKey = this.getIsPartitionKey();
        result = result * 59 + ($isPartitionKey == null ? 43 : ((Object)$isPartitionKey).hashCode());
        Integer $maxCapacity = this.getMaxCapacity();
        result = result * 59 + ($maxCapacity == null ? 43 : ((Object)$maxCapacity).hashCode());
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        DataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        DataType $elementType = this.getElementType();
        result = result * 59 + ($elementType == null ? 43 : $elementType.hashCode());
        return result;
    }

    public String toString() {
        return "MilvusField(fieldName=" + this.getFieldName() + ", dataType=" + this.getDataType() + ", isPrimaryKey=" + this.getIsPrimaryKey() + ", autoId=" + this.getAutoId() + ", description=" + this.getDescription() + ", dimension=" + this.getDimension() + ", maxLength=" + this.getMaxLength() + ", isPartitionKey=" + this.getIsPartitionKey() + ", elementType=" + this.getElementType() + ", maxCapacity=" + this.getMaxCapacity() + ")";
    }

    public MilvusField() {
    }

    public MilvusField(String fieldName, DataType dataType, Boolean isPrimaryKey, Boolean autoId, String description, Integer dimension, Integer maxLength, Boolean isPartitionKey, DataType elementType, Integer maxCapacity) {
        this.fieldName = fieldName;
        this.dataType = dataType;
        this.isPrimaryKey = isPrimaryKey;
        this.autoId = autoId;
        this.description = description;
        this.dimension = dimension;
        this.maxLength = maxLength;
        this.isPartitionKey = isPartitionKey;
        this.elementType = elementType;
        this.maxCapacity = maxCapacity;
    }

    public static class MilvusFieldBuilder {
        private String fieldName;
        private DataType dataType;
        private Boolean isPrimaryKey;
        private Boolean autoId;
        private String description;
        private Integer dimension;
        private Integer maxLength;
        private Boolean isPartitionKey;
        private DataType elementType;
        private Integer maxCapacity;

        MilvusFieldBuilder() {
        }

        public MilvusFieldBuilder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public MilvusFieldBuilder dataType(DataType dataType) {
            this.dataType = dataType;
            return this;
        }

        public MilvusFieldBuilder isPrimaryKey(Boolean isPrimaryKey) {
            this.isPrimaryKey = isPrimaryKey;
            return this;
        }

        public MilvusFieldBuilder autoId(Boolean autoId) {
            this.autoId = autoId;
            return this;
        }

        public MilvusFieldBuilder description(String description) {
            this.description = description;
            return this;
        }

        public MilvusFieldBuilder dimension(Integer dimension) {
            this.dimension = dimension;
            return this;
        }

        public MilvusFieldBuilder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public MilvusFieldBuilder isPartitionKey(Boolean isPartitionKey) {
            this.isPartitionKey = isPartitionKey;
            return this;
        }

        public MilvusFieldBuilder elementType(DataType elementType) {
            this.elementType = elementType;
            return this;
        }

        public MilvusFieldBuilder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public MilvusField build() {
            return new MilvusField(this.fieldName, this.dataType, this.isPrimaryKey, this.autoId, this.description, this.dimension, this.maxLength, this.isPartitionKey, this.elementType, this.maxCapacity);
        }

        public String toString() {
            return "MilvusField.MilvusFieldBuilder(fieldName=" + this.fieldName + ", dataType=" + this.dataType + ", isPrimaryKey=" + this.isPrimaryKey + ", autoId=" + this.autoId + ", description=" + this.description + ", dimension=" + this.dimension + ", maxLength=" + this.maxLength + ", isPartitionKey=" + this.isPartitionKey + ", elementType=" + this.elementType + ", maxCapacity=" + this.maxCapacity + ")";
        }
    }
}

