/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.service;

import io.milvus.v2.client.ConnectConfig;
import io.milvus.v2.client.MilvusClientV2;
import io.milvus.v2.service.collection.request.ReleaseCollectionReq;
import io.milvus.v2.service.utility.response.ListAliasResp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dromara.milvus.plus.annotation.MilvusCollection;
import org.dromara.milvus.plus.cache.CollectionToPrimaryCache;
import org.dromara.milvus.plus.converter.MilvusConverter;
import org.dromara.milvus.plus.model.MilvusEntity;
import org.dromara.milvus.plus.model.MilvusProperties;
import org.dromara.milvus.plus.service.ICMService;
import org.dromara.milvus.plus.service.MilvusClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

public abstract class AbstractMilvusClientBuilder
implements MilvusClientBuilder,
ICMService {
    private static final Logger log = LoggerFactory.getLogger(AbstractMilvusClientBuilder.class);
    protected MilvusProperties properties;
    protected MilvusClientV2 client;
    private static final String CLASS = "*.class";

    @Override
    public void initialize() {
        if (this.properties.isEnable()) {
            ConnectConfig connectConfig = ConnectConfig.builder().uri(this.properties.getUri()).token(this.properties.getToken()).dbName(this.properties.getDbName()).username(this.properties.getUsername()).password(this.properties.getPassword()).build();
            this.client = new MilvusClientV2(connectConfig);
            this.handler();
        }
    }

    @Override
    public void close() throws InterruptedException {
        if (this.client != null) {
            Set<String> co = CollectionToPrimaryCache.collectionToPrimary.keySet();
            if (!co.isEmpty()) {
                for (String name : co) {
                    ReleaseCollectionReq releaseCollectionReq = ReleaseCollectionReq.builder().collectionName(name).build();
                    this.client.releaseCollection(releaseCollectionReq);
                }
            }
            this.client.close(100L);
        }
    }

    public void handler() {
        List<Class<?>> classes;
        if (Objects.isNull(this.client)) {
            log.warn("initialize handler over!");
        }
        if ((classes = this.getClass(this.properties.getPackages())).isEmpty()) {
            log.warn("no any collections have been initialized, see if the [packages] parameter is configured correctly. :( !");
            return;
        }
        this.performBusinessLogic(classes);
    }

    @Override
    public MilvusClientV2 getClient() {
        return this.client;
    }

    private List<Class<?>> getClass(List<String> packages) {
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        return Optional.ofNullable(packages).orElseThrow(() -> new RuntimeException("model package is null, please configure the [packages] parameter")).stream().map(arg_0 -> AbstractMilvusClientBuilder.lambda$getClass$1((ResourcePatternResolver)resourcePatternResolver, arg_0)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void performBusinessLogic(List<Class<?>> annotatedClasses) {
        for (Class<?> milvusClass : annotatedClasses) {
            MilvusEntity milvusEntity = MilvusConverter.convert(milvusClass);
            this.createCollection(milvusEntity);
            this.aliasProcess(milvusEntity);
        }
    }

    private void aliasProcess(MilvusEntity milvusEntity) {
        if (StringUtils.isBlank((CharSequence)milvusEntity.getCollectionName()) || milvusEntity.getAlias() == null || milvusEntity.getAlias().isEmpty()) {
            return;
        }
        ListAliasResp listAliasResp = this.listAliases(milvusEntity);
        Optional.ofNullable(listAliasResp).ifPresent(aliasInfo -> {
            List<String> aliasList = milvusEntity.getAlias().stream().filter(e -> !aliasInfo.getAlias().contains(e)).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            log.info("processing alias: {}", aliasList);
            milvusEntity.setAlias(aliasList);
            this.createAlias(milvusEntity);
        });
    }

    public void setProperties(MilvusProperties properties) {
        this.properties = properties;
    }

    private static /* synthetic */ List lambda$getClass$1(ResourcePatternResolver resourcePatternResolver, String pg) {
        ArrayList res = new ArrayList();
        String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)(pg + ".")) + CLASS;
        try {
            Resource[] resources = resourcePatternResolver.getResources(pattern);
            CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
            for (Resource resource : resources) {
                MetadataReader reader = readerFactory.getMetadataReader(resource);
                String classname = reader.getClassMetadata().getClassName();
                Class<?> clazz = Class.forName(classname);
                MilvusCollection annotation = clazz.getAnnotation(MilvusCollection.class);
                if (annotation == null) continue;
                res.add(clazz);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return res;
    }
}

