/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.dromara.milvus.plus.annotation.AnalyzerParams;
import org.dromara.milvus.plus.annotation.BuiltInFilter;
import org.dromara.milvus.plus.annotation.CustomFilter;

public class AnalyzerParamsUtils {
    public static Map<String, Object> convertToMap(AnalyzerParams analyzerParams) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        if (analyzerParams != null) {
            paramsMap.put("tokenizer", analyzerParams.tokenizer().name().toLowerCase());
            ArrayList<String> builtInFiltersList = new ArrayList<String>();
            for (BuiltInFilter builtInFilter : analyzerParams.builtInFilters()) {
                builtInFiltersList.add(builtInFilter.name().name());
            }
            ArrayList customFiltersList = new ArrayList();
            for (CustomFilter customFilter : analyzerParams.customFilters()) {
                HashMap<String, Object> filterMap = new HashMap<String, Object>();
                filterMap.put("type", customFilter.type());
                if (customFilter.max() > 0) {
                    filterMap.put("max", customFilter.max());
                }
                if (customFilter.stopWords().length > 0) {
                    filterMap.put("stopWords", new ArrayList(Lists.newArrayList((Object[])customFilter.stopWords())));
                }
                customFiltersList.add(filterMap);
            }
            ArrayList<Object> filters = new ArrayList<Object>();
            filters.addAll(builtInFiltersList);
            filters.addAll(customFiltersList);
            paramsMap.put("filter", filters);
        }
        return paramsMap;
    }
}

