/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.core.conditions;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dromara.milvus.plus.core.FieldFunction;
import org.springframework.util.CollectionUtils;

public abstract class ConditionBuilder<T> {
    protected List<String> filters = new ArrayList<String>();
    protected List<String> textMatches = new ArrayList<String>();

    protected Map<String, Object> getPropertiesMap(T t) {
        Field[] fields;
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        Class<?> clazz = t.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                String fieldName = field.getName();
                Object value = field.get(t);
                if (value == null) continue;
                propertiesMap.put(fieldName, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing field", e);
            }
        }
        return propertiesMap;
    }

    protected ConditionBuilder<T> textMatch(String fieldName, List<String> values) {
        String joinedValues = String.join((CharSequence)" ", values);
        String match = "TEXT_MATCH(" + this.wrapFieldName(fieldName) + ", '" + joinedValues + "')";
        this.textMatches.add(match);
        return this;
    }

    protected ConditionBuilder<T> textMatch(String fieldName, String value) {
        String match = "TEXT_MATCH(" + this.wrapFieldName(fieldName) + ", '" + value + "')";
        this.textMatches.add(match);
        return this;
    }

    protected ConditionBuilder<T> textMatch(FieldFunction<T, ?> fieldName, String value) {
        this.textMatch(fieldName.getFieldName(fieldName), value);
        return this;
    }

    protected ConditionBuilder<T> textMatch(FieldFunction<T, ?> fieldName, List<String> values) {
        this.textMatch(fieldName.getFieldName(fieldName), values);
        return this;
    }

    protected ConditionBuilder<T> eq(String fieldName, Object value) {
        return this.addFilter(fieldName, "==", value);
    }

    protected ConditionBuilder<T> ne(String fieldName, Object value) {
        return this.addFilter(fieldName, "!=", value);
    }

    protected ConditionBuilder<T> gt(String fieldName, Object value) {
        return this.addFilter(fieldName, ">", value);
    }

    protected ConditionBuilder<T> ge(String fieldName, Object value) {
        return this.addFilter(fieldName, ">=", value);
    }

    protected ConditionBuilder<T> lt(String fieldName, Object value) {
        return this.addFilter(fieldName, "<", value);
    }

    protected ConditionBuilder<T> le(String fieldName, Object value) {
        return this.addFilter(fieldName, "<=", value);
    }

    protected ConditionBuilder<T> between(String fieldName, Object start, Object end) {
        String filter = String.format("%s >= %s && %s <= %s", this.wrapFieldName(fieldName), this.convertValue(start), this.wrapFieldName(fieldName), this.convertValue(end));
        this.filters.add(filter);
        return this;
    }

    protected ConditionBuilder<T> isNull(String fieldName) {
        this.filters.add(this.wrapFieldName(fieldName) + " == null");
        return this;
    }

    protected ConditionBuilder<T> isNotNull(String fieldName) {
        this.filters.add(this.wrapFieldName(fieldName) + " != null");
        return this;
    }

    protected ConditionBuilder<T> in(String fieldName, List<?> values) {
        String valueList = this.convertValues(values);
        this.filters.add(this.wrapFieldName(fieldName) + " in " + valueList);
        return this;
    }

    protected ConditionBuilder<T> like(String fieldName, String value) {
        this.filters.add(this.wrapFieldName(fieldName) + " like '%" + value + "%'");
        return this;
    }

    public ConditionBuilder<T> jsonContains(String fieldName, Object value) {
        this.filters.add("JSON_CONTAINS(" + fieldName + ", " + this.convertValue(value) + ")");
        return this;
    }

    public ConditionBuilder<T> jsonContainsAll(String fieldName, List<?> values) {
        String valueList = this.convertValues(values);
        this.filters.add("JSON_CONTAINS_ALL(" + fieldName + ", " + valueList + ")");
        return this;
    }

    public ConditionBuilder<T> jsonContainsAny(String fieldName, List<?> values) {
        String valueList = this.convertValues(values);
        this.filters.add("JSON_CONTAINS_ANY(" + fieldName + ", " + valueList + ")");
        return this;
    }

    public ConditionBuilder<T> arrayContains(String fieldName, Object value) {
        this.filters.add("ARRAY_CONTAINS(" + fieldName + ", " + this.convertValue(value) + ")");
        return this;
    }

    public ConditionBuilder<T> arrayContainsAll(String fieldName, List<?> values) {
        String valueList = this.convertValues(values);
        this.filters.add("ARRAY_CONTAINS_ALL(" + fieldName + ", " + valueList + ")");
        return this;
    }

    public ConditionBuilder<T> arrayContainsAny(String fieldName, List<?> values) {
        String valueList = this.convertValues(values);
        this.filters.add("ARRAY_CONTAINS_ANY(" + fieldName + ", " + valueList + ")");
        return this;
    }

    public ConditionBuilder<T> arrayLength(String fieldName, int length) {
        this.filters.add(fieldName + ".length() == " + length);
        return this;
    }

    public ConditionBuilder<T> eq(FieldFunction<T, ?> fieldName, Object value) {
        return this.addFilter(fieldName, "==", value);
    }

    public ConditionBuilder<T> ne(FieldFunction<T, ?> fieldName, Object value) {
        return this.addFilter(fieldName, "!=", value);
    }

    public ConditionBuilder<T> gt(FieldFunction<T, ?> fieldName, Object value) {
        return this.addFilter(fieldName, ">", value);
    }

    public ConditionBuilder<T> ge(FieldFunction<T, ?> fieldName, Object value) {
        return this.addFilter(fieldName, ">=", value);
    }

    public ConditionBuilder<T> lt(FieldFunction<T, ?> fieldName, Object value) {
        return this.addFilter(fieldName, "<", value);
    }

    public ConditionBuilder<T> le(FieldFunction<T, ?> fieldName, Object value) {
        return this.addFilter(fieldName, "<=", value);
    }

    public ConditionBuilder<T> between(FieldFunction<T, ?> fieldName, Object start, Object end) {
        String fn = this.getFieldName(fieldName);
        String filter = String.format("%s >= %s && %s <= %s", fn, this.convertValue(start), fn, this.convertValue(end));
        this.filters.add(filter);
        return this;
    }

    public ConditionBuilder<T> isNull(FieldFunction<T, ?> fieldName) {
        String fn = this.getFieldName(fieldName);
        this.filters.add(fn + " == null");
        return this;
    }

    public ConditionBuilder<T> isNotNull(FieldFunction<T, ?> fieldName) {
        String fn = this.getFieldName(fieldName);
        this.filters.add(fn + " != null");
        return this;
    }

    public ConditionBuilder<T> in(FieldFunction<T, ?> fieldName, List<?> values) {
        String fn = this.getFieldName(fieldName);
        String valueList = values.stream().map(this::convertValue).collect(Collectors.joining(", ", "[", "]"));
        this.filters.add(fn + " in " + valueList);
        return this;
    }

    public ConditionBuilder<T> like(FieldFunction<T, ?> fieldName, String value) {
        String fn = this.getFieldName(fieldName);
        this.filters.add(fn + " like '%" + value + "%'");
        return this;
    }

    protected ConditionBuilder<T> likeLeft(String fieldName, String value) {
        this.filters.add(this.wrapFieldName(fieldName) + " like '" + value + "%'");
        return this;
    }

    protected ConditionBuilder<T> likeRight(String fieldName, String value) {
        this.filters.add(this.wrapFieldName(fieldName) + " like '%'" + value + "'");
        return this;
    }

    protected ConditionBuilder<T> likeLeft(FieldFunction<T, ?> fieldName, String value) {
        String fn = this.getFieldName(fieldName);
        this.filters.add(fn + " like '" + value + "%'");
        return this;
    }

    protected ConditionBuilder<T> likeRight(FieldFunction<T, ?> fieldName, String value) {
        String fn = this.getFieldName(fieldName);
        this.filters.add(fn + " like '%" + value + "'");
        return this;
    }

    public ConditionBuilder<T> jsonContains(FieldFunction<T, ?> fieldName, Object value) {
        String fn = this.getFieldName(fieldName);
        this.filters.add("JSON_CONTAINS(" + fn + ", " + this.convertValue(value) + ")");
        return this;
    }

    public ConditionBuilder<T> jsonContainsAll(FieldFunction<T, ?> fieldName, List<?> values) {
        String fn = this.getFieldName(fieldName);
        String valueList = this.convertValues(values);
        this.filters.add("JSON_CONTAINS_ALL(" + fn + ", " + valueList + ")");
        return this;
    }

    public ConditionBuilder<T> jsonContainsAny(FieldFunction<T, ?> fieldName, List<?> values) {
        String fn = this.getFieldName(fieldName);
        String valueList = this.convertValues(values);
        this.filters.add("JSON_CONTAINS_ANY(" + fn + ", " + valueList + ")");
        return this;
    }

    public ConditionBuilder<T> arrayContains(FieldFunction<T, ?> fieldName, Object value) {
        String fn = this.getFieldName(fieldName);
        this.filters.add("ARRAY_CONTAINS(" + fn + ", " + this.convertValue(value) + ")");
        return this;
    }

    public ConditionBuilder<T> arrayContainsAll(FieldFunction<T, ?> fieldName, List<?> values) {
        String fn = this.getFieldName(fieldName);
        String valueList = this.convertValues(values);
        this.filters.add("ARRAY_CONTAINS_ALL(" + fn + ", " + valueList + ")");
        return this;
    }

    public ConditionBuilder<T> arrayContainsAny(FieldFunction<T, ?> fieldName, List<?> values) {
        String fn = this.getFieldName(fieldName);
        String valueList = this.convertValues(values);
        this.filters.add("ARRAY_CONTAINS_ANY(" + fn + ", " + valueList + ")");
        return this;
    }

    public ConditionBuilder<T> arrayLength(FieldFunction<T, ?> fieldName, int length) {
        String fn = this.getFieldName(fieldName);
        this.filters.add(fn + ".length() == " + length);
        return this;
    }

    public ConditionBuilder<T> and(ConditionBuilder<T> other) {
        this.filters.add("(" + String.join((CharSequence)" && ", other.filters) + ")");
        return this;
    }

    public ConditionBuilder<T> or(ConditionBuilder<T> other) {
        this.filters.add("(" + String.join((CharSequence)" || ", other.filters) + ")");
        return this;
    }

    public ConditionBuilder<T> not() {
        this.filters.add("not (" + String.join((CharSequence)" && ", this.filters) + ")");
        return this;
    }

    protected String buildFilters() {
        if (!CollectionUtils.isEmpty(this.textMatches)) {
            String textMatchFilter = this.textMatches.stream().collect(Collectors.joining(" and "));
            this.filters.add(textMatchFilter);
        }
        return this.filters.stream().collect(Collectors.joining(" && "));
    }

    private String getFieldName(FieldFunction<T, ?> fieldFunction) {
        return fieldFunction.getFieldName(fieldFunction);
    }

    protected String convertValue(Object value) {
        if (value instanceof String) {
            return "'" + value.toString().replace("'", "\\'") + "'";
        }
        return value.toString();
    }

    protected String convertValues(List<?> values) {
        return values.stream().map(this::convertValue).collect(Collectors.joining(", ", "[", "]"));
    }

    protected String wrapFieldName(String fieldName) {
        return fieldName;
    }

    protected ConditionBuilder<T> addFilter(String fieldName, String op, Object value) {
        this.filters.add(this.wrapFieldName(fieldName) + " " + op + " " + this.convertValue(value));
        return this;
    }

    protected ConditionBuilder<T> addFilter(FieldFunction<T, ?> fieldName, String op, Object value) {
        this.filters.add(this.wrapFieldName(this.getFieldName(fieldName)) + " " + op + " " + this.convertValue(value));
        return this;
    }
}

