/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.core.conditions;

import io.milvus.exception.MilvusException;
import io.milvus.v2.client.MilvusClientV2;
import io.milvus.v2.service.vector.request.DeleteReq;
import io.milvus.v2.service.vector.response.DeleteResp;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dromara.milvus.plus.cache.ConversionCache;
import org.dromara.milvus.plus.core.FieldFunction;
import org.dromara.milvus.plus.core.conditions.AbstractChainWrapper;
import org.dromara.milvus.plus.core.conditions.ConditionBuilder;
import org.dromara.milvus.plus.core.conditions.Wrapper;
import org.dromara.milvus.plus.model.vo.MilvusResp;
import org.dromara.milvus.plus.util.GsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaDeleteWrapper<T>
extends AbstractChainWrapper<T>
implements Wrapper<LambdaDeleteWrapper<T>, T> {
    private static final Logger log = LoggerFactory.getLogger(LambdaDeleteWrapper.class);
    private ConversionCache conversionCache;
    private Class<T> entityType;
    private String collectionName;
    private String partitionName;
    private MilvusClientV2 client;
    private List<Object> ids = new ArrayList<Object>();

    public LambdaDeleteWrapper(String collectionName, MilvusClientV2 client, ConversionCache conversionCache, Class<T> entityType) {
        this.collectionName = collectionName;
        this.client = client;
        this.conversionCache = conversionCache;
        this.entityType = entityType;
    }

    public LambdaDeleteWrapper() {
    }

    public LambdaDeleteWrapper<T> partition(String partitionName) {
        this.partitionName = partitionName;
        return this;
    }

    public LambdaDeleteWrapper<T> partition(FieldFunction<T, ?> partitionName) {
        this.partitionName = partitionName.getFieldName(partitionName);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> eq(String fieldName, Object value) {
        super.eq(fieldName, value);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> ne(String fieldName, Object value) {
        super.ne(fieldName, value);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> gt(String fieldName, Object value) {
        super.gt(fieldName, value);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> ge(String fieldName, Object value) {
        super.ge(fieldName, value);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> lt(String fieldName, Object value) {
        super.lt(fieldName, value);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> le(String fieldName, Object value) {
        super.le(fieldName, value);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> between(String fieldName, Object start, Object end) {
        super.between(fieldName, start, end);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> isNull(String fieldName) {
        super.isNull(fieldName);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> isNotNull(String fieldName) {
        super.isNotNull(fieldName);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> in(String fieldName, List<?> values) {
        super.in(fieldName, values);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> like(String fieldName, String value) {
        super.like(fieldName, value);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> likeLeft(String fieldName, String value) {
        super.likeLeft(fieldName, value);
        return this;
    }

    public LambdaDeleteWrapper<T> likeLeft(boolean condition, String fieldName, String value) {
        if (condition) {
            super.likeLeft(fieldName, value);
        }
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> likeLeft(FieldFunction<T, ?> fieldName, String value) {
        super.likeLeft(fieldName, value);
        return this;
    }

    public LambdaDeleteWrapper<T> likeLeft(boolean condition, FieldFunction<T, ?> fieldName, String value) {
        if (condition) {
            super.likeLeft(fieldName, value);
        }
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> likeRight(String fieldName, String value) {
        super.likeRight(fieldName, value);
        return this;
    }

    public LambdaDeleteWrapper<T> likeRight(boolean condition, String fieldName, String value) {
        if (condition) {
            super.likeRight(fieldName, value);
        }
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> likeRight(FieldFunction<T, ?> fieldName, String value) {
        super.likeRight(fieldName, value);
        return this;
    }

    public LambdaDeleteWrapper<T> likeRight(boolean condition, FieldFunction<T, ?> fieldName, String value) {
        if (condition) {
            super.likeRight(fieldName, value);
        }
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> jsonContains(String fieldName, Object value) {
        super.jsonContains(fieldName, value);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> jsonContainsAll(String fieldName, List<?> values) {
        super.jsonContainsAll(fieldName, values);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> jsonContainsAny(String fieldName, List<?> values) {
        super.jsonContainsAny(fieldName, values);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> arrayContains(String fieldName, Object value) {
        super.arrayContains(fieldName, value);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> arrayContainsAll(String fieldName, List<?> values) {
        super.arrayContainsAll(fieldName, values);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> arrayContainsAny(String fieldName, List<?> values) {
        super.arrayContainsAny(fieldName, values);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> arrayLength(String fieldName, int length) {
        super.arrayLength(fieldName, length);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> eq(FieldFunction<T, ?> fieldName, Object value) {
        super.eq(fieldName, value);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> ne(FieldFunction<T, ?> fieldName, Object value) {
        super.ne(fieldName, value);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> gt(FieldFunction<T, ?> fieldName, Object value) {
        super.gt(fieldName, value);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> ge(FieldFunction<T, ?> fieldName, Object value) {
        super.ge(fieldName, value);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> lt(FieldFunction<T, ?> fieldName, Object value) {
        super.lt(fieldName, value);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> le(FieldFunction<T, ?> fieldName, Object value) {
        super.le(fieldName, value);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> between(FieldFunction<T, ?> fieldName, Object start, Object end) {
        super.between(fieldName, start, end);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> isNull(FieldFunction<T, ?> fieldName) {
        super.isNull(fieldName);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> isNotNull(FieldFunction<T, ?> fieldName) {
        super.isNotNull(fieldName);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> in(FieldFunction<T, ?> fieldName, List<?> values) {
        super.in(fieldName, values);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> like(FieldFunction<T, ?> fieldName, String value) {
        super.like(fieldName, value);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> jsonContains(FieldFunction<T, ?> fieldName, Object value) {
        super.jsonContains(fieldName, value);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> jsonContainsAll(FieldFunction<T, ?> fieldName, List<?> values) {
        super.jsonContainsAll(fieldName, values);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> jsonContainsAny(FieldFunction<T, ?> fieldName, List<?> values) {
        super.jsonContainsAny(fieldName, values);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> arrayContains(FieldFunction<T, ?> fieldName, Object value) {
        super.arrayContains(fieldName, value);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> arrayContainsAll(FieldFunction<T, ?> fieldName, List<?> values) {
        super.arrayContainsAll(fieldName, values);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> arrayContainsAny(FieldFunction<T, ?> fieldName, List<?> values) {
        super.arrayContainsAny(fieldName, values);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> arrayLength(FieldFunction<T, ?> fieldName, int length) {
        super.arrayLength(fieldName, length);
        return this;
    }

    public LambdaDeleteWrapper<T> eq(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.eq(fieldName, value);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> ne(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.ne(fieldName, value);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> gt(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.gt(fieldName, value);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> ge(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.ge(fieldName, value);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> lt(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.lt(fieldName, value);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> le(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.le(fieldName, value);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> between(boolean condition, String fieldName, Object start, Object end) {
        if (condition) {
            super.between(fieldName, start, end);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> in(boolean condition, String fieldName, List<?> values) {
        if (condition) {
            super.in(fieldName, values);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> like(boolean condition, String fieldName, String value) {
        if (condition) {
            super.like(fieldName, value);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> jsonContains(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.jsonContains(fieldName, value);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> jsonContainsAll(boolean condition, String fieldName, List<?> values) {
        if (condition) {
            super.jsonContainsAll(fieldName, values);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> jsonContainsAny(boolean condition, String fieldName, List<?> values) {
        if (condition) {
            super.jsonContainsAny(fieldName, values);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> arrayContains(boolean condition, String fieldName, Object value) {
        if (condition) {
            super.arrayContains(fieldName, value);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> arrayContainsAll(boolean condition, String fieldName, List<?> values) {
        if (condition) {
            super.arrayContainsAll(fieldName, values);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> arrayContainsAny(boolean condition, String fieldName, List<?> values) {
        if (condition) {
            super.arrayContainsAny(fieldName, values);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> arrayLength(boolean condition, String fieldName, int length) {
        if (condition) {
            super.arrayLength(fieldName, length);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> eq(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.eq(fieldName, value);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> ne(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.ne(fieldName, value);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> gt(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.gt(fieldName, value);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> ge(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.ge(fieldName, value);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> lt(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.lt(fieldName, value);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> le(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.le(fieldName, value);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> between(boolean condition, FieldFunction<T, ?> fieldName, Object start, Object end) {
        if (condition) {
            super.between(fieldName, start, end);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> in(boolean condition, FieldFunction<T, ?> fieldName, List<?> values) {
        if (condition) {
            super.in(fieldName, values);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> like(boolean condition, FieldFunction<T, ?> fieldName, String value) {
        if (condition) {
            super.like(fieldName, value);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> jsonContains(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.jsonContains(fieldName, value);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> jsonContainsAll(boolean condition, FieldFunction<T, ?> fieldName, List<?> values) {
        if (condition) {
            super.jsonContainsAll(fieldName, values);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> jsonContainsAny(boolean condition, FieldFunction<T, ?> fieldName, List<?> values) {
        if (condition) {
            super.jsonContainsAny(fieldName, values);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> arrayContains(boolean condition, FieldFunction<T, ?> fieldName, Object value) {
        if (condition) {
            super.arrayContains(fieldName, value);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> arrayContainsAll(boolean condition, FieldFunction<T, ?> fieldName, List<?> values) {
        if (condition) {
            super.arrayContainsAll(fieldName, values);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> arrayContainsAny(boolean condition, FieldFunction<T, ?> fieldName, List<?> values) {
        if (condition) {
            super.arrayContainsAny(fieldName, values);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> arrayLength(boolean condition, FieldFunction<T, ?> fieldName, int length) {
        if (condition) {
            super.arrayLength(fieldName, length);
        }
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> textMatch(String fieldName, List<String> values) {
        super.textMatch(fieldName, values);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> textMatch(String fieldName, String value) {
        super.textMatch(fieldName, value);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> textMatch(FieldFunction<T, ?> fieldName, String value) {
        super.textMatch(fieldName, value);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> textMatch(FieldFunction<T, ?> fieldName, List<String> values) {
        super.textMatch(fieldName, values);
        return this;
    }

    public LambdaDeleteWrapper<T> textMatch(boolean condition, String fieldName, List<String> values) {
        if (condition) {
            super.textMatch(fieldName, values);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> textMatch(boolean condition, String fieldName, String value) {
        if (condition) {
            super.textMatch(fieldName, value);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> textMatch(boolean condition, FieldFunction<T, ?> fieldName, String value) {
        if (condition) {
            super.textMatch(fieldName, value);
        }
        return this;
    }

    public LambdaDeleteWrapper<T> textMatch(boolean condition, FieldFunction<T, ?> fieldName, List<String> values) {
        if (condition) {
            super.textMatch(fieldName, values);
        }
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> and(ConditionBuilder<T> other) {
        super.and(other);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> or(ConditionBuilder<T> other) {
        super.or(other);
        return this;
    }

    @Override
    public LambdaDeleteWrapper<T> not() {
        super.not();
        return this;
    }

    public LambdaDeleteWrapper<T> id(Object id) {
        this.ids.add(id);
        return this;
    }

    public LambdaDeleteWrapper<T> id(Object ... id) {
        this.ids.addAll(Arrays.asList(id));
        return this;
    }

    public LambdaDeleteWrapper<T> id(List<Object> ids) {
        this.ids.addAll(ids);
        return this;
    }

    private DeleteReq build() {
        DeleteReq.DeleteReqBuilder builder = DeleteReq.builder().collectionName(this.collectionName);
        String filterStr = this.buildFilters();
        if (filterStr != null && !filterStr.isEmpty()) {
            builder.filter(filterStr);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.partitionName)) {
            builder.partitionName(this.partitionName);
        }
        if (!this.ids.isEmpty()) {
            builder.ids(this.ids);
        }
        return builder.build();
    }

    public MilvusResp<DeleteResp> remove() throws MilvusException {
        return this.executeWithRetry(() -> {
            DeleteReq deleteReq = this.build();
            log.info("build remove param-->{}", (Object)GsonUtil.toJson(deleteReq));
            DeleteResp delete = this.client.delete(deleteReq);
            MilvusResp<DeleteResp> resp = new MilvusResp<DeleteResp>();
            resp.setData(delete);
            resp.setSuccess(true);
            return resp;
        }, "collection not loaded", 2, this.entityType, this.client);
    }

    public MilvusResp<DeleteResp> removeById(Serializable ... ids) throws MilvusException {
        this.id(ids);
        return this.remove();
    }

    @Override
    public void init(String collectionName, MilvusClientV2 client, ConversionCache conversionCache, Class<T> entityType) {
        this.setClient(client);
        this.setCollectionName(collectionName);
        this.setEntityType(entityType);
        this.setConversionCache(conversionCache);
    }

    @Override
    public LambdaDeleteWrapper<T> wrapper() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LambdaDeleteWrapper)) {
            return false;
        }
        LambdaDeleteWrapper other = (LambdaDeleteWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConversionCache this$conversionCache = this.getConversionCache();
        ConversionCache other$conversionCache = other.getConversionCache();
        if (this$conversionCache == null ? other$conversionCache != null : !((Object)this$conversionCache).equals(other$conversionCache)) {
            return false;
        }
        Class<T> this$entityType = this.getEntityType();
        Class<T> other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        if (this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName)) {
            return false;
        }
        String this$partitionName = this.getPartitionName();
        String other$partitionName = other.getPartitionName();
        if (this$partitionName == null ? other$partitionName != null : !this$partitionName.equals(other$partitionName)) {
            return false;
        }
        MilvusClientV2 this$client = this.getClient();
        MilvusClientV2 other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        List<Object> this$ids = this.getIds();
        List<Object> other$ids = other.getIds();
        return !(this$ids == null ? other$ids != null : !((Object)this$ids).equals(other$ids));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LambdaDeleteWrapper;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ConversionCache $conversionCache = this.getConversionCache();
        result = result * 59 + ($conversionCache == null ? 43 : ((Object)$conversionCache).hashCode());
        Class<T> $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        String $partitionName = this.getPartitionName();
        result = result * 59 + ($partitionName == null ? 43 : $partitionName.hashCode());
        MilvusClientV2 $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        List<Object> $ids = this.getIds();
        result = result * 59 + ($ids == null ? 43 : ((Object)$ids).hashCode());
        return result;
    }

    public ConversionCache getConversionCache() {
        return this.conversionCache;
    }

    public Class<T> getEntityType() {
        return this.entityType;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public MilvusClientV2 getClient() {
        return this.client;
    }

    public List<Object> getIds() {
        return this.ids;
    }

    public void setConversionCache(ConversionCache conversionCache) {
        this.conversionCache = conversionCache;
    }

    public void setEntityType(Class<T> entityType) {
        this.entityType = entityType;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    public void setClient(MilvusClientV2 client) {
        this.client = client;
    }

    public void setIds(List<Object> ids) {
        this.ids = ids;
    }

    @Override
    public String toString() {
        return "LambdaDeleteWrapper(conversionCache=" + this.getConversionCache() + ", entityType=" + this.getEntityType() + ", collectionName=" + this.getCollectionName() + ", partitionName=" + this.getPartitionName() + ", client=" + this.getClient() + ", ids=" + this.getIds() + ")";
    }
}

