/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.service;

import com.google.gson.JsonObject;
import io.milvus.exception.MilvusException;
import io.milvus.v2.client.MilvusClientV2;
import io.milvus.v2.common.ConsistencyLevel;
import io.milvus.v2.service.vector.request.DeleteReq;
import io.milvus.v2.service.vector.request.GetReq;
import io.milvus.v2.service.vector.request.InsertReq;
import io.milvus.v2.service.vector.request.QueryReq;
import io.milvus.v2.service.vector.request.SearchReq;
import io.milvus.v2.service.vector.request.UpsertReq;
import io.milvus.v2.service.vector.request.data.BaseVector;
import io.milvus.v2.service.vector.response.DeleteResp;
import io.milvus.v2.service.vector.response.GetResp;
import io.milvus.v2.service.vector.response.InsertResp;
import io.milvus.v2.service.vector.response.QueryResp;
import io.milvus.v2.service.vector.response.SearchResp;
import io.milvus.v2.service.vector.response.UpsertResp;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface IVecMService {
    public MilvusClientV2 getClient();

    default public DeleteResp delete(String collectionName, String partitionName, String filter, List<Object> ids) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        DeleteReq deleteReq = DeleteReq.builder().collectionName(collectionName).partitionName(partitionName).filter(filter).ids(ids).build();
        return client.delete(deleteReq);
    }

    default public DeleteResp deleteByFilter(String collectionName, String filter) throws MilvusException {
        return this.delete(collectionName, null, filter, null);
    }

    default public DeleteResp deleteByIds(String collectionName, List<Object> ids) throws MilvusException {
        return this.delete(collectionName, null, "", ids);
    }

    default public GetResp get(String collectionName, String partitionName, List<Object> ids, List<String> outputFields) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        GetReq getReq = GetReq.builder().collectionName(collectionName).partitionName(partitionName).ids(ids).outputFields(outputFields).build();
        return client.get(getReq);
    }

    default public GetResp getByIds(String collectionName, List<Object> ids) throws MilvusException {
        return this.get(collectionName, null, ids, Collections.emptyList());
    }

    default public GetResp getById(String collectionName, Object id) throws MilvusException {
        return this.get(collectionName, null, Collections.singletonList(id), Collections.emptyList());
    }

    default public InsertResp insert(String collectionName, List<JsonObject> data, String partitionName) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        InsertReq insertReq = InsertReq.builder().collectionName(collectionName).data(data).partitionName(partitionName).build();
        return client.insert(insertReq);
    }

    default public InsertResp insert(String collectionName, JsonObject data) throws MilvusException {
        return this.insert(collectionName, Collections.singletonList(data), null);
    }

    default public QueryResp query(String collectionName, List<String> partitionNames, List<String> outputFields, List<Object> ids, String filter, ConsistencyLevel consistencyLevel, long offset, long limit) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        QueryReq queryReq = QueryReq.builder().collectionName(collectionName).partitionNames(partitionNames).outputFields(outputFields).ids(ids).filter(filter).consistencyLevel(consistencyLevel).offset(offset).limit(limit).build();
        return client.query(queryReq);
    }

    default public QueryResp queryByFilter(String collectionName, List<String> outputFields, String filter, ConsistencyLevel consistencyLevel, long offset, long limit) throws MilvusException {
        return this.query(collectionName, Collections.emptyList(), outputFields, Collections.emptyList(), filter, consistencyLevel, offset, limit);
    }

    default public SearchResp search(String collectionName, List<String> partitionNames, String annsField, int topK, String filter, List<String> outputFields, List<BaseVector> data, long offset, long limit, int roundDecimal, Map<String, Object> searchParams, long guaranteeTimestamp, long gracefulTime, ConsistencyLevel consistencyLevel, boolean ignoreGrowing) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        SearchReq searchReq = SearchReq.builder().collectionName(collectionName).partitionNames(partitionNames).annsField(annsField).topK(topK).filter(filter).outputFields(outputFields).data(data).offset(offset).limit(limit).roundDecimal(roundDecimal).searchParams(searchParams).guaranteeTimestamp(guaranteeTimestamp).gracefulTime(Long.valueOf(gracefulTime)).consistencyLevel(consistencyLevel).ignoreGrowing(ignoreGrowing).build();
        return client.search(searchReq);
    }

    default public SearchResp search(String collectionName, List<BaseVector> data, int topK) throws MilvusException {
        return this.search(collectionName, Collections.emptyList(), null, topK, "", Collections.emptyList(), data, 0L, 0L, -1, Collections.emptyMap(), 0L, 0L, ConsistencyLevel.BOUNDED, false);
    }

    default public UpsertResp upsert(String collectionName, String partitionName, List<JsonObject> data) throws MilvusException {
        MilvusClientV2 client = this.getClient();
        UpsertReq upsertReq = UpsertReq.builder().collectionName(collectionName).partitionName(partitionName).data(data).build();
        return client.upsert(upsertReq);
    }

    default public UpsertResp upsert(String collectionName, JsonObject data) throws MilvusException {
        return this.upsert(collectionName, null, Collections.singletonList(data));
    }
}

