/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dromara.milvus.plus.annotation.AnalyzerParams;
import org.dromara.milvus.plus.annotation.CustomFilter;
import org.dromara.milvus.plus.annotation.Filter;
import org.dromara.milvus.plus.model.BuiltInFilterType;
import org.springframework.util.CollectionUtils;

public class AnalyzerParamsUtils {
    public static Map<String, Object> convertToMap(AnalyzerParams analyzerParams) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        if (analyzerParams != null) {
            String tokenizer;
            String type = analyzerParams.type();
            if (StringUtils.isNotEmpty((CharSequence)type)) {
                paramsMap.put("type", type);
            }
            if (StringUtils.isNotEmpty((CharSequence)(tokenizer = analyzerParams.tokenizer()))) {
                paramsMap.put("tokenizer", tokenizer);
            }
            Filter filter = analyzerParams.filter();
            ArrayList<String> builtInFiltersList = new ArrayList<String>();
            ArrayList customFiltersList = new ArrayList();
            if (filter != null) {
                BuiltInFilterType[] builtInFilterTypes;
                CustomFilter[] customFilters = filter.customFilters();
                for (BuiltInFilterType builtInFilterType : builtInFilterTypes = filter.builtInFilters()) {
                    builtInFiltersList.add(builtInFilterType.name());
                }
                for (CustomFilter customFilter : customFilters) {
                    HashMap<String, Object> filterMap = new HashMap<String, Object>();
                    filterMap.put("type", customFilter.type());
                    if (customFilter.max() > 0) {
                        filterMap.put("max", customFilter.max());
                    }
                    if (customFilter.stopWords().length > 0) {
                        filterMap.put("stop_words", new ArrayList(Lists.newArrayList((Object[])customFilter.stopWords())));
                    }
                    customFiltersList.add(filterMap);
                }
            }
            ArrayList<Object> filters = new ArrayList<Object>();
            filters.addAll(builtInFiltersList);
            filters.addAll(customFiltersList);
            if (!CollectionUtils.isEmpty(filters)) {
                paramsMap.put("filter", filters);
            }
        }
        return paramsMap;
    }
}

