/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.util;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;

public final class GsonUtil {
    private GsonUtil() {
    }

    public static Gson createGson() {
        return new GsonBuilder().setPrettyPrinting().serializeNulls().registerTypeAdapter(Date.class, (Object)new DateSerializer()).registerTypeAdapter(Date.class, (Object)new DateDeserializer()).create();
    }

    public static Gson createGsonWithAdapters(JsonSerializer<?> ... serializersAndDeserializers) {
        GsonBuilder builder = new GsonBuilder();
        for (JsonSerializer<?> serializer : serializersAndDeserializers) {
            builder.registerTypeAdapter(serializer.getClass(), serializer);
        }
        return builder.create();
    }

    public static String toJson(Object object) {
        return GsonUtil.createGson().toJson(object);
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return (T)GsonUtil.createGson().fromJson(json, clazz);
    }

    public static <K, V> Map<K, V> fromJsonToMap(String json) {
        return (Map)GsonUtil.createGson().fromJson(json, new TypeToken<Map<K, V>>(){}.getType());
    }

    public static <T> List<T> fromJsonToList(String json, Class<T> clazz) {
        return (List)GsonUtil.createGson().fromJson(json, new TypeToken<List<T>>(){}.getType());
    }

    public static JsonArray fromJsonToJsonArray(String json) {
        return (JsonArray)GsonUtil.createGson().fromJson(json, JsonArray.class);
    }

    public static <T> T convertMapToType(Map<String, Object> map, Type type) {
        Gson gson = GsonUtil.createGson();
        String json = gson.toJson(map);
        return (T)gson.fromJson(json, type);
    }

    public static void put(JsonObject jsonObject, String key, Object value) {
        Gson gson = GsonUtil.createGson();
        if (value instanceof String) {
            jsonObject.addProperty(key, (String)value);
        } else if (value instanceof Number) {
            jsonObject.addProperty(key, (Number)value);
        } else if (value instanceof Boolean) {
            jsonObject.addProperty(key, (Boolean)value);
        } else {
            jsonObject.add(key, gson.toJsonTree(value));
        }
    }

    private static class DateDeserializer
    implements JsonDeserializer<Date> {
        private DateDeserializer() {
        }

        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new Date(json.getAsJsonPrimitive().getAsLong());
        }
    }

    private static class DateSerializer
    implements JsonSerializer<Date> {
        private DateSerializer() {
        }

        public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src.getTime());
        }
    }
}

