/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;

public class IdWorkerUtils {
    private static final long twepoch = 1288834974657L;
    private static final long workerIdBits = 5L;
    private static final long datacenterIdBits = 5L;
    private static final long maxWorkerId = 31L;
    private static final long maxDatacenterId = 31L;
    private static final long sequenceBits = 12L;
    private static final long workerIdShift = 12L;
    private static final long datacenterIdShift = 17L;
    private static final long timestampLeftShift = 22L;
    private static final long sequenceMask = 4095L;
    private static long lastTimestamp = -1L;
    private static long sequence = 0L;
    private static long datacenterId = IdWorkerUtils.getDatacenterId(31L);
    private static long workerId = IdWorkerUtils.getMaxWorkerId();

    public static synchronized long nextId() {
        long timestamp = IdWorkerUtils.timeGen();
        if (timestamp < lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards. Refusing to generate id for %d milliseconds", lastTimestamp - timestamp));
        }
        if (lastTimestamp == timestamp) {
            if ((sequence = sequence + 1L & 0xFFFL) == 0L) {
                timestamp = IdWorkerUtils.tilNextMillis(lastTimestamp);
            }
        } else {
            sequence = 0L;
        }
        lastTimestamp = timestamp;
        long nextId = timestamp - 1288834974657L << 22 | datacenterId << 17 | workerId << 12 | sequence;
        return nextId;
    }

    private static long tilNextMillis(long lastTimestamp) {
        long timestamp = IdWorkerUtils.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = IdWorkerUtils.timeGen();
        }
        return timestamp;
    }

    private static long timeGen() {
        return System.currentTimeMillis();
    }

    private static long getMaxWorkerId() {
        long maxWorkerId = 0L;
        try {
            ArrayList<NetworkInterface> networkInterfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface networkInterface : networkInterfaces) {
                byte[] macBytes;
                if (!networkInterface.getName().contains("eth") && !networkInterface.getName().contains("wlan") || (macBytes = networkInterface.getHardwareAddress()) == null) continue;
                maxWorkerId |= (long)((macBytes[macBytes.length - 1] & 0xFF | (macBytes[macBytes.length - 2] & 0xFF) << 8) & 0xFFFF);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return maxWorkerId >> 10 & 0x3FFL;
    }

    private static long getDatacenterId(long maxDatacenterId) {
        long id = 0L;
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network == null) {
                id = 1L;
            } else {
                byte[] mac = network.getHardwareAddress();
                id = (0xFFL & (long)mac[mac.length - 1] | 0xFF00L & (long)mac[mac.length - 2] << 8) >> 6;
                id %= maxDatacenterId + 1L;
            }
        }
        catch (Exception e) {
            System.out.println(" getDatacenterId: " + e.getMessage());
        }
        return id;
    }
}

