/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.core;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.dromara.milvus.plus.annotation.MilvusField;
import org.dromara.milvus.plus.cache.ConversionCache;
import org.dromara.milvus.plus.cache.MilvusCache;

@FunctionalInterface
public interface FieldFunction<T, R>
extends Function<T, R>,
Serializable {
    public static final String DEFAULT_SPLIT = "";
    public static final int DEFAULT_TO_TYPE = 0;

    default public String getFieldName(FieldFunction<T, ?> fn, String split, int toType) {
        String fieldName;
        SerializedLambda lambda = this.getSerializedLambda(fn);
        String implClass = lambda.getImplClass().replace("/", ".");
        String implMethodName = lambda.getImplMethodName();
        ConversionCache conversionCache = MilvusCache.milvusCache.get(implClass);
        String string = fieldName = conversionCache != null ? conversionCache.getPropertyCache().methodToPropertyMap.get(implMethodName) : this.extractFieldName(implClass, implMethodName);
        if (StringUtils.isNotEmpty((CharSequence)fieldName)) {
            return fieldName;
        }
        return this.transformFieldName(fieldName, split, toType);
    }

    default public SerializedLambda getSerializedLambda(FieldFunction<T, ?> function) {
        return Optional.ofNullable(function).map(this::extractSerializedLambda).orElseThrow(() -> new RuntimeException("\u4f20\u5165\u7684\u51fd\u6570\u5bf9\u8c61\u4e3anull\u6216\u6ca1\u6709writeReplace\u65b9\u6cd5"));
    }

    default public SerializedLambda extractSerializedLambda(FieldFunction<T, ?> function) {
        Method writeReplaceMethod;
        try {
            writeReplaceMethod = function.getClass().getDeclaredMethod("writeReplace", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("\u672a\u627e\u5230writeReplace\u65b9\u6cd5", e);
        }
        boolean isAccessible = writeReplaceMethod.isAccessible();
        try {
            writeReplaceMethod.setAccessible(true);
            SerializedLambda serializedLambda = (SerializedLambda)writeReplaceMethod.invoke(function, new Object[0]);
            return serializedLambda;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("\u8c03\u7528writeReplace\u65b9\u6cd5\u5931\u8d25", e);
        }
        finally {
            writeReplaceMethod.setAccessible(isAccessible);
        }
    }

    default public String capitalizeFirstLetter(String str, boolean capitalize) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        char firstChar = str.charAt(0);
        char newChar = capitalize ? Character.toUpperCase(firstChar) : Character.toLowerCase(firstChar);
        return newChar + str.substring(1);
    }

    default public String extractFieldName(String className, String methodName) {
        String fieldName = this.capitalizeFirstLetter(methodName.substring(3), false);
        try {
            Field field = Class.forName(className).getDeclaredField(fieldName);
            MilvusField annotation = field.getAnnotation(MilvusField.class);
            return annotation != null && StringUtils.isNotBlank((CharSequence)annotation.name()) ? annotation.name() : fieldName;
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    default public String transformFieldName(String fieldName, String split, int toType) {
        switch (toType) {
            case 1: {
                return fieldName.replaceAll("([A-Z])", split + "$1").toUpperCase();
            }
            case 2: {
                return fieldName.replaceAll("([A-Z])", split + "$1").toLowerCase();
            }
        }
        return fieldName.replaceAll("([A-Z])", split + "$1");
    }

    default public String getFieldName(FieldFunction<T, ?> fn) {
        return this.getFieldName(fn, DEFAULT_SPLIT, 0);
    }
}

