/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.core.conditions;

import com.google.gson.JsonObject;
import io.milvus.exception.MilvusException;
import io.milvus.v2.client.MilvusClientV2;
import io.milvus.v2.service.vector.request.InsertReq;
import io.milvus.v2.service.vector.response.InsertResp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dromara.milvus.plus.cache.CollectionToPrimaryCache;
import org.dromara.milvus.plus.cache.ConversionCache;
import org.dromara.milvus.plus.cache.MilvusCache;
import org.dromara.milvus.plus.cache.PropertyCache;
import org.dromara.milvus.plus.core.FieldFunction;
import org.dromara.milvus.plus.core.conditions.AbstractChainWrapper;
import org.dromara.milvus.plus.core.conditions.Wrapper;
import org.dromara.milvus.plus.model.vo.MilvusResp;
import org.dromara.milvus.plus.util.GsonUtil;
import org.dromara.milvus.plus.util.IdWorkerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaInsertWrapper<T>
extends AbstractChainWrapper<T>
implements Wrapper<LambdaInsertWrapper<T>, T> {
    private static final Logger log = LoggerFactory.getLogger(LambdaInsertWrapper.class);
    private ConversionCache conversionCache;
    private Class<T> entityType;
    private String collectionName;
    private String partitionName;
    private MilvusClientV2 client;
    private JsonObject entity = new JsonObject();

    public LambdaInsertWrapper(String collectionName, MilvusClientV2 client, ConversionCache conversionCache, Class<T> entityType) {
        this.collectionName = collectionName;
        this.client = client;
        this.conversionCache = conversionCache;
        this.entityType = entityType;
    }

    public LambdaInsertWrapper() {
    }

    public LambdaInsertWrapper<T> put(FieldFunction<T, ?> fieldName, Object value) {
        GsonUtil.put(this.entity, fieldName.getFieldName(fieldName), value);
        return this;
    }

    public LambdaInsertWrapper<T> put(String fieldName, Object value) {
        GsonUtil.put(this.entity, fieldName, value);
        return this;
    }

    public LambdaInsertWrapper<T> partition(String partitionName) {
        this.partitionName = partitionName;
        return this;
    }

    public LambdaInsertWrapper<T> partition(FieldFunction<T, ?> partitionName) {
        this.partitionName = partitionName.getFieldName(partitionName);
        return this;
    }

    public MilvusResp<InsertResp> insert() {
        if (!this.entity.isJsonNull()) {
            return this.insert(Collections.singletonList(this.entity));
        }
        throw new MilvusException("not insert data", Integer.valueOf(400));
    }

    private MilvusResp<InsertResp> insert(List<JsonObject> jsonObjects) {
        return this.executeWithRetry(() -> {
            log.info("insert data--->{}", (Object)GsonUtil.toJson(jsonObjects));
            InsertReq.InsertReqBuilder builder = InsertReq.builder().collectionName(this.collectionName).data(jsonObjects);
            if (StringUtils.isNotEmpty((CharSequence)this.partitionName)) {
                builder.partitionName(this.partitionName);
            }
            InsertReq insertReq = builder.build();
            InsertResp insert = this.client.insert(insertReq);
            MilvusResp<InsertResp> resp = new MilvusResp<InsertResp>();
            resp.setData(insert);
            resp.setSuccess(true);
            return resp;
        }, "collection not loaded", 2, this.entityType, this.client);
    }

    @SafeVarargs
    public final MilvusResp<InsertResp> insert(T ... entity) throws MilvusException {
        AbstractChainWrapper.ArrayIterator<T> iterator = new AbstractChainWrapper.ArrayIterator<T>(entity);
        return this.insert(iterator);
    }

    public MilvusResp<InsertResp> insert(Iterator<T> iterator) throws MilvusException {
        ConversionCache conversionCache = MilvusCache.milvusCache.get(this.entityType.getName());
        PropertyCache propertyCache = conversionCache.getPropertyCache();
        String pk = CollectionToPrimaryCache.collectionToPrimary.get(this.collectionName);
        ArrayList<JsonObject> jsonObjects = new ArrayList<JsonObject>();
        while (iterator.hasNext()) {
            T t1 = iterator.next();
            Map<String, Object> propertiesMap = this.getPropertiesMap(t1);
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry<String, Object> entry : propertiesMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                String tk = propertyCache.functionToPropertyMap.get(key);
                if (!StringUtils.isNotEmpty((CharSequence)tk)) continue;
                GsonUtil.put(jsonObject, tk, value);
            }
            if (conversionCache.isAutoID()) {
                GsonUtil.put(jsonObject, pk, IdWorkerUtils.nextId());
            }
            jsonObjects.add(jsonObject);
        }
        return this.insert((List<JsonObject>)jsonObjects);
    }

    @Override
    public void init(String collectionName, MilvusClientV2 client, ConversionCache conversionCache, Class<T> entityType) {
        this.setClient(client);
        this.setCollectionName(collectionName);
        this.setEntityType(entityType);
        this.setConversionCache(conversionCache);
    }

    @Override
    public LambdaInsertWrapper<T> wrapper() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LambdaInsertWrapper)) {
            return false;
        }
        LambdaInsertWrapper other = (LambdaInsertWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConversionCache this$conversionCache = this.getConversionCache();
        ConversionCache other$conversionCache = other.getConversionCache();
        if (this$conversionCache == null ? other$conversionCache != null : !((Object)this$conversionCache).equals(other$conversionCache)) {
            return false;
        }
        Class<T> this$entityType = this.getEntityType();
        Class<T> other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        if (this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName)) {
            return false;
        }
        String this$partitionName = this.getPartitionName();
        String other$partitionName = other.getPartitionName();
        if (this$partitionName == null ? other$partitionName != null : !this$partitionName.equals(other$partitionName)) {
            return false;
        }
        MilvusClientV2 this$client = this.getClient();
        MilvusClientV2 other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        JsonObject this$entity = this.getEntity();
        JsonObject other$entity = other.getEntity();
        return !(this$entity == null ? other$entity != null : !this$entity.equals(other$entity));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LambdaInsertWrapper;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ConversionCache $conversionCache = this.getConversionCache();
        result = result * 59 + ($conversionCache == null ? 43 : ((Object)$conversionCache).hashCode());
        Class<T> $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        String $partitionName = this.getPartitionName();
        result = result * 59 + ($partitionName == null ? 43 : $partitionName.hashCode());
        MilvusClientV2 $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        JsonObject $entity = this.getEntity();
        result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
        return result;
    }

    public ConversionCache getConversionCache() {
        return this.conversionCache;
    }

    public Class<T> getEntityType() {
        return this.entityType;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public MilvusClientV2 getClient() {
        return this.client;
    }

    public JsonObject getEntity() {
        return this.entity;
    }

    public void setConversionCache(ConversionCache conversionCache) {
        this.conversionCache = conversionCache;
    }

    public void setEntityType(Class<T> entityType) {
        this.entityType = entityType;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    public void setClient(MilvusClientV2 client) {
        this.client = client;
    }

    public void setEntity(JsonObject entity) {
        this.entity = entity;
    }

    @Override
    public String toString() {
        return "LambdaInsertWrapper(conversionCache=" + this.getConversionCache() + ", entityType=" + this.getEntityType() + ", collectionName=" + this.getCollectionName() + ", partitionName=" + this.getPartitionName() + ", client=" + this.getClient() + ", entity=" + this.getEntity() + ")";
    }
}

