/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.core.mapper;

import io.milvus.v2.client.MilvusClientV2;
import io.milvus.v2.service.vector.response.DeleteResp;
import io.milvus.v2.service.vector.response.InsertResp;
import io.milvus.v2.service.vector.response.UpsertResp;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.dromara.milvus.plus.annotation.MilvusCollection;
import org.dromara.milvus.plus.cache.ConversionCache;
import org.dromara.milvus.plus.cache.MilvusCache;
import org.dromara.milvus.plus.core.conditions.LambdaDeleteWrapper;
import org.dromara.milvus.plus.core.conditions.LambdaInsertWrapper;
import org.dromara.milvus.plus.core.conditions.LambdaQueryWrapper;
import org.dromara.milvus.plus.core.conditions.LambdaUpdateWrapper;
import org.dromara.milvus.plus.core.conditions.Wrapper;
import org.dromara.milvus.plus.model.vo.MilvusResp;
import org.dromara.milvus.plus.model.vo.MilvusResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMilvusMapper<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseMilvusMapper.class);

    public abstract MilvusClientV2 getClient();

    public LambdaQueryWrapper<T> queryWrapper() {
        return (LambdaQueryWrapper)this.lambda(new LambdaQueryWrapper());
    }

    public LambdaDeleteWrapper<T> deleteWrapper() {
        return (LambdaDeleteWrapper)this.lambda(new LambdaDeleteWrapper());
    }

    public LambdaUpdateWrapper<T> updateWrapper() {
        return (LambdaUpdateWrapper)this.lambda(new LambdaUpdateWrapper());
    }

    public LambdaInsertWrapper<T> insertWrapper() {
        return (LambdaInsertWrapper)this.lambda(new LambdaInsertWrapper());
    }

    public MilvusResp<List<MilvusResult<T>>> getById(Serializable ... ids) {
        LambdaQueryWrapper<T> lambda = this.queryWrapper();
        return lambda.getById(ids);
    }

    public MilvusResp<DeleteResp> removeById(Serializable ... ids) {
        LambdaDeleteWrapper<T> lambda = this.deleteWrapper();
        return lambda.removeById(ids);
    }

    public MilvusResp<InsertResp> insert(T ... entity) {
        LambdaInsertWrapper<T> lambda = this.insertWrapper();
        return lambda.insert(entity);
    }

    public MilvusResp<InsertResp> insert(Collection<T> entity) {
        LambdaInsertWrapper<T> lambda = this.insertWrapper();
        return lambda.insert(entity.iterator());
    }

    public MilvusResp<UpsertResp> updateById(T ... entity) {
        LambdaUpdateWrapper<T> lambda = this.updateWrapper();
        return lambda.updateById(entity);
    }

    public MilvusResp<UpsertResp> updateById(Collection<T> entity) {
        LambdaUpdateWrapper<T> lambda = this.updateWrapper();
        return lambda.updateById(entity.iterator());
    }

    public <W> W lambda(Wrapper<W, T> wrapper) {
        Type type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        Class entityType = (Class)type;
        return this.lambda(entityType, wrapper);
    }

    public <W> W lambda(Class<T> entityType, Wrapper<W, T> wrapper) {
        MilvusCollection collectionAnnotation = entityType.getAnnotation(MilvusCollection.class);
        if (collectionAnnotation == null) {
            throw new IllegalStateException("Entity type " + entityType.getName() + " is not annotated with @MilvusCollection.");
        }
        ConversionCache conversionCache = MilvusCache.milvusCache.get(entityType.getName());
        String collectionName = conversionCache == null ? null : conversionCache.getCollectionName();
        MilvusClientV2 client = this.getClient();
        wrapper.init(collectionName, client, conversionCache, entityType);
        return wrapper.wrapper();
    }
}

