/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.log;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.ServiceLoader;
import org.dromara.milvus.plus.log.spi.LogFrameworkAdapter;

public class LogAdapterFactory {
    private static volatile LogFrameworkAdapter cachedAdapter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LogFrameworkAdapter getAdapter() {
        if (cachedAdapter != null) return cachedAdapter;
        Class<LogAdapterFactory> clazz = LogAdapterFactory.class;
        synchronized (LogAdapterFactory.class) {
            if (cachedAdapter != null) return cachedAdapter;
            ServiceLoader<LogFrameworkAdapter> loader = ServiceLoader.load(LogFrameworkAdapter.class);
            ArrayList<LogFrameworkAdapter> adapters = new ArrayList<LogFrameworkAdapter>();
            for (LogFrameworkAdapter adapter : loader) {
                if (!adapter.isSupported()) continue;
                adapters.add(adapter);
            }
            if (adapters.isEmpty()) {
                throw new IllegalStateException("No supported logging framework found! Please add one of:\n- Logback: ch.qos.logback:logback-classic\n- Log4j2: org.apache.logging.log4j:log4j-core + log4j-slf4j2-impl\n- JUL: JDK built-in (no extra dependencies needed)");
            }
            adapters.sort(Comparator.comparingInt(LogFrameworkAdapter::getPriority));
            cachedAdapter = (LogFrameworkAdapter)adapters.get(0);
            // ** MonitorExit[var0] (shouldn't be in output)
            return cachedAdapter;
        }
    }
}

