/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.converter;

import com.google.common.collect.Lists;
import io.milvus.common.clientenum.FunctionType;
import io.milvus.v2.client.MilvusClientV2;
import io.milvus.v2.common.ConsistencyLevel;
import io.milvus.v2.common.DataType;
import io.milvus.v2.common.IndexParam;
import io.milvus.v2.service.collection.request.AddFieldReq;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.service.collection.request.GetLoadStateReq;
import io.milvus.v2.service.collection.request.LoadCollectionReq;
import io.milvus.v2.service.partition.request.CreatePartitionReq;
import io.milvus.v2.service.partition.request.HasPartitionReq;
import io.milvus.v2.service.partition.request.LoadPartitionsReq;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.dromara.milvus.plus.annotation.ExtraParam;
import org.dromara.milvus.plus.annotation.MilvusCollection;
import org.dromara.milvus.plus.annotation.MilvusField;
import org.dromara.milvus.plus.annotation.MilvusIndex;
import org.dromara.milvus.plus.annotation.MilvusPartition;
import org.dromara.milvus.plus.builder.CollectionSchemaBuilder;
import org.dromara.milvus.plus.cache.CollectionToPrimaryCache;
import org.dromara.milvus.plus.cache.ConversionCache;
import org.dromara.milvus.plus.cache.MilvusCache;
import org.dromara.milvus.plus.cache.PropertyCache;
import org.dromara.milvus.plus.model.MilvusEntity;
import org.dromara.milvus.plus.util.AnalyzerParamsUtils;
import org.dromara.milvus.plus.util.GsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class MilvusConverter {
    private static final Logger log = LoggerFactory.getLogger(MilvusConverter.class);

    public static MilvusEntity convert(Class<?> entityClass) {
        ConversionCache cache = MilvusCache.milvusCache.get(entityClass.getName());
        if (Objects.nonNull(cache)) {
            return cache.getMilvusEntity();
        }
        MilvusEntity milvus = new MilvusEntity();
        boolean autoID = false;
        MilvusCollection collectionAnnotation = entityClass.getAnnotation(MilvusCollection.class);
        if (Objects.isNull(collectionAnnotation)) {
            throw new IllegalArgumentException("Entity must be annotated with @MilvusCollection");
        }
        MilvusPartition milvusPartition = entityClass.getAnnotation(MilvusPartition.class);
        if (Objects.nonNull(milvusPartition)) {
            Object[] name = milvusPartition.name();
            milvus.setPartitionName(Lists.newArrayList((Object[])name));
        } else {
            milvus.setPartitionName(Lists.newArrayList());
        }
        String collectionName = collectionAnnotation.name();
        milvus.setCollectionName(collectionName);
        boolean enableDynamicField = collectionAnnotation.enableDynamicField();
        milvus.setEnableDynamicField(enableDynamicField);
        ConsistencyLevel level = collectionAnnotation.level();
        milvus.setConsistencyLevel(level);
        if (collectionAnnotation.alias().length > 0) {
            milvus.setAlias(Arrays.asList(collectionAnnotation.alias()));
        }
        ArrayList<AddFieldReq> milvusFields = new ArrayList<AddFieldReq>();
        ArrayList<IndexParam> indexParams = new ArrayList<IndexParam>();
        PropertyCache propertyCache = new PropertyCache();
        List<Field> fields = MilvusConverter.getAllFieldsFromClass(entityClass);
        ArrayList<CreateCollectionReq.Function> functions = new ArrayList<CreateCollectionReq.Function>();
        for (Field field : fields) {
            MilvusField fieldAnnotation = field.getAnnotation(MilvusField.class);
            if (Objects.isNull(fieldAnnotation)) continue;
            String fieldName = fieldAnnotation.name().isEmpty() ? field.getName() : fieldAnnotation.name();
            propertyCache.functionToPropertyMap.put(field.getName(), fieldName);
            propertyCache.nullableToPropertyMap.put(field.getName(), fieldAnnotation.nullable());
            propertyCache.methodToPropertyMap.put(MilvusConverter.getGetMethodName(field), fieldName);
            if (fieldAnnotation.isPrimaryKey()) {
                CollectionToPrimaryCache.collectionToPrimary.put(collectionName, fieldName);
            }
            AddFieldReq.AddFieldReqBuilder builder = AddFieldReq.builder().fieldName(fieldName).dataType(fieldAnnotation.dataType()).isPrimaryKey(Boolean.valueOf(fieldAnnotation.isPrimaryKey())).isPartitionKey(Boolean.valueOf(fieldAnnotation.isPartitionKey())).elementType(fieldAnnotation.elementType()).enableAnalyzer(Boolean.valueOf(fieldAnnotation.enableAnalyzer())).enableMatch(Boolean.valueOf(fieldAnnotation.enableMatch())).isNullable(Boolean.valueOf(fieldAnnotation.nullable())).autoID(Boolean.valueOf(false));
            boolean bl = autoID = autoID ? autoID : fieldAnnotation.autoID();
            if (fieldAnnotation.enableAnalyzer() && fieldAnnotation.dataType() == DataType.VarChar) {
                Map<String, Object> analyzerParams = AnalyzerParamsUtils.convertToMap(fieldAnnotation.analyzerParams());
                log.info("-----------analyzerParams--------- \n" + GsonUtil.toJson(analyzerParams));
                builder.analyzerParams(analyzerParams);
                AddFieldReq sparse = AddFieldReq.builder().fieldName(fieldName + "_sparse").dataType(DataType.SparseFloatVector).build();
                milvusFields.add(sparse);
                IndexParam sparseIndex = IndexParam.builder().indexName(fieldName + "_sparse_index").fieldName(fieldName + "_sparse").indexType(IndexParam.IndexType.AUTOINDEX).metricType(IndexParam.MetricType.BM25).build();
                indexParams.add(sparseIndex);
                String funName = fieldName + "_bm25_emb";
                CreateCollectionReq.Function fun = CreateCollectionReq.Function.builder().name(funName).functionType(FunctionType.BM25).inputFieldNames((List)Lists.newArrayList((Object[])new String[]{fieldName})).outputFieldNames((List)Lists.newArrayList((Object[])new String[]{fieldName + "_sparse"})).build();
                functions.add(fun);
            }
            Optional.of(fieldAnnotation.description()).filter(StringUtils::isNotEmpty).ifPresent(arg_0 -> ((AddFieldReq.AddFieldReqBuilder)builder).description(arg_0));
            Optional.of(fieldAnnotation.dimension()).filter(dimension -> dimension > 0).ifPresent(dimension -> builder.dimension(dimension));
            Optional.of(fieldAnnotation.maxLength()).filter(maxLength -> maxLength > 0).ifPresent(arg_0 -> ((AddFieldReq.AddFieldReqBuilder)builder).maxLength(arg_0));
            Optional.of(fieldAnnotation.maxCapacity()).filter(maxCapacity -> maxCapacity > 0).ifPresent(arg_0 -> ((AddFieldReq.AddFieldReqBuilder)builder).maxCapacity(arg_0));
            milvusFields.add(builder.build());
            MilvusConverter.createIndexParam(field, fieldName).ifPresent(indexParams::add);
        }
        milvus.setMilvusFields(milvusFields);
        milvus.setIndexParams(indexParams);
        milvus.setFunctions(functions);
        ConversionCache conversionCache = new ConversionCache();
        conversionCache.setMilvusEntity(milvus);
        conversionCache.setCollectionName(collectionName);
        conversionCache.setPropertyCache(propertyCache);
        conversionCache.setAutoID(autoID);
        MilvusCache.milvusCache.put(entityClass.getName(), conversionCache);
        return milvus;
    }

    public static List<Field> getAllFieldsFromClass(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null && clazz != Object.class) {
            fields.addAll(Stream.of(clazz.getDeclaredFields()).peek(field -> field.setAccessible(true)).collect(Collectors.toList()));
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    private static Optional<IndexParam> createIndexParam(Field field, String fieldName) {
        MilvusIndex fieldAnnotation = field.getAnnotation(MilvusIndex.class);
        if (fieldAnnotation == null) {
            return Optional.empty();
        }
        Map<String, Object> map = Optional.ofNullable(fieldAnnotation.extraParams()).map(Arrays::stream).orElseGet(Stream::empty).collect(Collectors.toMap(ExtraParam::key, ExtraParam::value, (old, current) -> current));
        IndexParam build = IndexParam.builder().indexName(fieldAnnotation.indexName().isEmpty() ? fieldName : fieldAnnotation.indexName()).fieldName(fieldName).indexType(fieldAnnotation.indexType()).metricType(fieldAnnotation.metricType()).extraParams(map).build();
        return Optional.of(build);
    }

    public static String getGetMethodName(Field field) {
        if (field == null) {
            throw new IllegalArgumentException("Field must not be null.");
        }
        String prefix = field.getType() == Boolean.TYPE || field.getType() == Boolean.class ? "is" : "get";
        String fieldName = MilvusConverter.capitalizeFirstLetter(field.getName());
        return prefix + fieldName;
    }

    private static String capitalizeFirstLetter(String original) {
        if (original == null || original.isEmpty()) {
            return original;
        }
        return original.substring(0, 1).toUpperCase() + original.substring(1);
    }

    public static void create(MilvusEntity milvusEntity, MilvusClientV2 client) {
        List<IndexParam> indexParams = milvusEntity.getIndexParams();
        if (indexParams == null || indexParams.isEmpty()) {
            throw new IllegalArgumentException("the index does not exist, please define the index");
        }
        CollectionSchemaBuilder schemaBuilder = new CollectionSchemaBuilder(milvusEntity.getEnableDynamicField(), milvusEntity.getCollectionName(), client);
        schemaBuilder.addField(milvusEntity.getMilvusFields().toArray(new AddFieldReq[0]));
        schemaBuilder.addConsistencyLevel(milvusEntity.getConsistencyLevel());
        schemaBuilder.addFun(milvusEntity.getFunctions());
        log.info("-------create schema---------");
        schemaBuilder.createSchema();
        log.info("-------create schema fun---------");
        schemaBuilder.createIndex(indexParams);
        log.info("-------create index---------");
        List<String> partitionName = milvusEntity.getPartitionName();
        if (CollectionUtils.isEmpty(partitionName)) {
            return;
        }
        for (String pn : partitionName) {
            CreatePartitionReq req = CreatePartitionReq.builder().collectionName(milvusEntity.getCollectionName()).partitionName(pn).build();
            client.createPartition(req);
        }
    }

    public static void loadStatus(MilvusEntity milvusEntity, MilvusClientV2 client) {
        List<String> partitionName;
        GetLoadStateReq getLoadStateReq = GetLoadStateReq.builder().collectionName(milvusEntity.getCollectionName()).build();
        Boolean resp = client.getLoadState(getLoadStateReq);
        log.info("load collection state-->{}", (Object)resp);
        if (!resp.booleanValue()) {
            LoadCollectionReq loadCollectionReq = LoadCollectionReq.builder().collectionName(milvusEntity.getCollectionName()).build();
            client.loadCollection(loadCollectionReq);
            log.info("load collection--{}", (Object)milvusEntity.getCollectionName());
        }
        if (CollectionUtils.isEmpty(partitionName = milvusEntity.getPartitionName())) {
            return;
        }
        for (String pn : partitionName) {
            HasPartitionReq hasPartitionReq = HasPartitionReq.builder().collectionName(milvusEntity.getCollectionName()).partitionName(pn).build();
            Boolean hasPartition = client.hasPartition(hasPartitionReq);
            log.info("has partition -->{}--{}", (Object)pn, (Object)hasPartition);
            if (hasPartition.booleanValue()) continue;
            CreatePartitionReq req = CreatePartitionReq.builder().collectionName(milvusEntity.getCollectionName()).partitionName(pn).build();
            client.createPartition(req);
            log.info("create partition -->{}", (Object)pn);
        }
        LoadPartitionsReq loadPartitionsReq = LoadPartitionsReq.builder().collectionName(milvusEntity.getCollectionName()).partitionNames(partitionName).build();
        client.loadPartitions(loadPartitionsReq);
        log.info("load partition--{}", milvusEntity.getPartitionName());
    }

    public static boolean isListFloat(Field field) {
        if (field == null) {
            return false;
        }
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Type rawType = parameterizedType.getRawType();
        if (!(rawType instanceof Class) || !List.class.isAssignableFrom((Class)rawType)) {
            return false;
        }
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        return typeArguments.length == 1 && typeArguments[0] == Float.class;
    }
}

