/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.milvus.plus.log.spi.impl;

import java.lang.reflect.Method;
import org.dromara.milvus.plus.log.spi.LogFrameworkAdapter;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LogbackAdapter
implements LogFrameworkAdapter {
    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean isSupported() {
        try {
            Class.forName("ch.qos.logback.classic.Logger");
            Class.forName("ch.qos.logback.classic.Level");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public void setLogLevel(String packageName, String level) {
        try {
            Class<?> loggerContextClass = Class.forName("ch.qos.logback.classic.LoggerContext");
            Class<?> levelClass = Class.forName("ch.qos.logback.classic.Level");
            Method toLevelMethod = levelClass.getMethod("toLevel", String.class);
            Object logLevel = toLevelMethod.invoke(null, level);
            ILoggerFactory loggerContext = LoggerFactory.getILoggerFactory();
            if (!loggerContextClass.isInstance(loggerContext)) {
                throw new IllegalStateException("LoggerFactory is not Logback");
            }
            Method getLoggerListMethod = loggerContextClass.getMethod("getLoggerList", new Class[0]);
            Iterable loggers = (Iterable)getLoggerListMethod.invoke((Object)loggerContext, new Object[0]);
            for (Object logger : loggers) {
                Method getNameMethod = logger.getClass().getMethod("getName", new Class[0]);
                String name = (String)getNameMethod.invoke(logger, new Object[0]);
                if (!name.startsWith(packageName)) continue;
                Method setLevelMethod = logger.getClass().getMethod("setLevel", levelClass);
                setLevelMethod.invoke(logger, logLevel);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("[Logback] Set log level failed: " + e.getMessage(), e);
        }
    }
}

