/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mpe.annotation.handler;

import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.extension.handlers.AbstractJsonTypeHandler;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import java.io.IOException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedTypes(value={Object.class})
@MappedJdbcTypes(value={JdbcType.VARCHAR})
public class CustomJacksonTypeHandler
extends AbstractJsonTypeHandler<Object> {
    private static final Logger log = LoggerFactory.getLogger(CustomJacksonTypeHandler.class);
    private static ObjectMapper OBJECT_MAPPER;
    private final Class<?> type;

    public CustomJacksonTypeHandler(Class<?> type) {
        super(type);
        if (log.isTraceEnabled()) {
            log.trace("CustomJacksonTypeHandler(" + type + ")");
        }
        Assert.notNull(type, (String)"Type argument cannot be null", (Object[])new Object[0]);
        this.type = type;
    }

    public Object parse(String json) {
        try {
            return CustomJacksonTypeHandler.getObjectMapper().readValue(json, this.type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toJson(Object obj) {
        try {
            return CustomJacksonTypeHandler.getObjectMapper().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectMapper getObjectMapper() {
        if (null == OBJECT_MAPPER) {
            OBJECT_MAPPER = new ObjectMapper();
            CustomJacksonTypeHandler.init(OBJECT_MAPPER);
            CustomJacksonTypeHandler.initTypeInclusion(OBJECT_MAPPER);
        }
        return OBJECT_MAPPER;
    }

    public static void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper should not be null", (Object[])new Object[0]);
        OBJECT_MAPPER = objectMapper;
    }

    protected static void init(ObjectMapper objectMapper) {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setVisibility(objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN});
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY});
        objectMapper.addMixIn(Throwable.class, ThrowableMixIn.class);
        OBJECT_MAPPER = objectMapper;
    }

    protected static void initTypeInclusion(ObjectMapper mapObjectMapper) {
        ObjectMapper.DefaultTypeResolverBuilder mapTyper = new ObjectMapper.DefaultTypeResolverBuilder(ObjectMapper.DefaultTyping.NON_FINAL, (PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance){

            public boolean useForType(JavaType t) {
                switch (this._appliesFor) {
                    case NON_CONCRETE_AND_ARRAYS: {
                        while (t.isArrayType()) {
                            t = t.getContentType();
                        }
                    }
                    case OBJECT_AND_NON_CONCRETE: {
                        return t.getRawClass() == Object.class || !t.isConcrete();
                    }
                    case NON_FINAL: {
                        while (t.isArrayType()) {
                            t = t.getContentType();
                        }
                        if (t.getRawClass() == Long.class) {
                            return true;
                        }
                        if (t.getRawClass() == XMLGregorianCalendar.class) {
                            return false;
                        }
                        return !t.isFinal();
                    }
                }
                return t.getRawClass() == Object.class;
            }
        };
        mapTyper.init(JsonTypeInfo.Id.CLASS, null);
        mapTyper.inclusion(JsonTypeInfo.As.PROPERTY);
        mapObjectMapper.setDefaultTyping((TypeResolverBuilder)mapTyper);
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@id")
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class ThrowableMixIn {
    }
}

