/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mpe.bind.binder;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.dromara.mpe.bind.binder.IBinder;
import org.dromara.mpe.bind.builder.ResultBuilder;
import org.dromara.mpe.bind.metadata.BindEntityDescription;
import org.dromara.mpe.bind.metadata.FieldDescription;
import org.dromara.mpe.bind.metadata.JoinConditionDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class BindEntityBinder<BEAN>
implements IBinder<BEAN, BindEntityDescription, JoinConditionDescription> {
    private static final Logger log = LoggerFactory.getLogger(BindEntityBinder.class);

    @Override
    public <ENTITY> void fillData(List<BEAN> beans, FieldDescription.ConditionSign<ENTITY, JoinConditionDescription> conditionSign, final List<BindEntityDescription> fieldAnnotations) {
        ResultBuilder.FillDataCallback fillDataCallback = new ResultBuilder.FillDataCallback(){

            @Override
            public String[] selectColumns(List<?> beans, FieldDescription.ConditionSign<?, JoinConditionDescription> entityJoinCondition, List<? extends FieldDescription<?, JoinConditionDescription>> fieldAnnotationList) {
                for (BindEntityDescription fieldAnnotation : fieldAnnotations) {
                    if (!fieldAnnotation.getSelectColumns().isEmpty()) continue;
                    return new String[0];
                }
                Set<String> columns = fieldAnnotations.stream().map(BindEntityDescription::getSelectColumns).flatMap(Collection::stream).collect(Collectors.toSet());
                if (!columns.isEmpty()) {
                    for (JoinConditionDescription condition : entityJoinCondition.getConditions()) {
                        columns.add(condition.getJoinColumnName());
                    }
                }
                return columns.toArray(new String[0]);
            }

            @Override
            public List<?> changeDataList(Object bean, FieldDescription<?, JoinConditionDescription> fieldAnnotation, List<?> entities) {
                BindEntityDescription entityDescription = (BindEntityDescription)fieldAnnotation;
                if (entityDescription.getEntityClass() != entityDescription.getFieldClass()) {
                    return entities.stream().map(entity -> {
                        try {
                            Object newInstance = entityDescription.getFieldClass().newInstance();
                            BeanUtils.copyProperties((Object)entity, newInstance);
                            return newInstance;
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            throw new RuntimeException(entityDescription.getEntityClass() + "\u8f6c" + entityDescription.getFieldClass() + "\u7684\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef\u3002", e);
                        }
                    }).collect(Collectors.toList());
                }
                return entities;
            }
        };
        ResultBuilder.newInstance(beans, conditionSign, fieldAnnotations, fillDataCallback).fillData();
    }

    private BindEntityBinder() {
    }

    public static <BEAN> BindEntityBinder<BEAN> newInstance() {
        return new BindEntityBinder<BEAN>();
    }
}

