/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mpe.bind.builder;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dromara.mpe.bind.CollectionSplitter;
import org.dromara.mpe.bind.metadata.FieldDescription;
import org.dromara.mpe.bind.metadata.MidConditionDescription;
import org.dromara.mpe.bind.metadata.OrderByDescription;
import org.dromara.mpe.magic.MapperExecuter;
import org.springframework.util.StringUtils;

public class ByMidResultBuilder<BEAN, ENTITY> {
    private final List<BEAN> beans;
    private final FieldDescription.ConditionSign<ENTITY, MidConditionDescription> conditionSign;
    private final List<? extends FieldDescription<?, MidConditionDescription>> fieldDescriptions;
    private final FillDataCallback fillDataCallback;

    public void fillData() {
        MidConditionDescription midConditionDescription = this.conditionSign.getConditions().get(0);
        Map<String, List<ENTITY>> joinEntityMap = this.listEntitiesByCondition(midConditionDescription);
        for (BEAN bean : this.beans) {
            String selfFieldVal = this.getSelfFieldValFromBean(midConditionDescription, bean);
            List entities = joinEntityMap.getOrDefault(selfFieldVal, Collections.emptyList());
            for (FieldDescription<?, MidConditionDescription> fieldAnnotation : this.fieldDescriptions) {
                List<Object> dataList = entities;
                if (this.fillDataCallback != null) {
                    this.fillDataCallback.fillBefore(bean, fieldAnnotation, dataList);
                    dataList = this.fillDataCallback.changeDataList(bean, fieldAnnotation, dataList);
                }
                this.fullDataToBeanField(bean, fieldAnnotation, dataList);
            }
        }
    }

    private Map<String, List<ENTITY>> listEntitiesByCondition(MidConditionDescription midConditionDescription) {
        List midDataList = this.listMidData(midConditionDescription);
        Map midDataListMap = midDataList.stream().collect(Collectors.groupingBy(midData -> {
            try {
                return midConditionDescription.getSelfMidFieldGetMethod().invoke(midData, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, Collectors.mapping(midData -> {
            try {
                return midConditionDescription.getJoinMidFieldGetMethod().invoke(midData, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, Collectors.toList())));
        Set<Object> joinMidFieldVals = midDataListMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        List<ENTITY> entities = this.listEntities(midConditionDescription, joinMidFieldVals);
        Map entitiesMap = entities.stream().collect(Collectors.toMap(ent -> {
            try {
                return midConditionDescription.getJoinFieldGetMethod().invoke(ent, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, Function.identity()));
        HashMap dataMap = new HashMap(midDataListMap.size());
        midDataListMap.forEach((selfVal, joinValList) -> dataMap.put(selfVal.toString(), joinValList.stream().map(entitiesMap::get).filter(Objects::nonNull).collect(Collectors.toList())));
        return dataMap;
    }

    private List<ENTITY> listEntities(MidConditionDescription midConditionDescription, Set<Object> joinMidFieldValSet) {
        if (joinMidFieldValSet.isEmpty()) {
            return Collections.emptyList();
        }
        List<List<Object>> joinMidFieldValList = CollectionSplitter.splitList(joinMidFieldValSet, 500);
        String[] selectColumns = this.fillDataCallback.selectColumns(this.beans, this.conditionSign, this.fieldDescriptions);
        return joinMidFieldValList.parallelStream().map(joinMidFieldVals -> {
            QueryWrapper queryWrapper = new QueryWrapper();
            if (selectColumns != null && selectColumns.length > 0) {
                queryWrapper.select((Object[])selectColumns);
            }
            queryWrapper.in((Object)midConditionDescription.getJoinColumnName(), (Collection)joinMidFieldVals);
            queryWrapper.apply(StringUtils.hasText((String)this.conditionSign.getCustomCondition()), this.conditionSign.getCustomCondition(), new Object[0]);
            for (OrderByDescription orderBy : this.conditionSign.getOrderBys()) {
                queryWrapper.orderBy(true, orderBy.isAsc(), (Object)orderBy.getColumnName());
            }
            queryWrapper.last(this.conditionSign.getLast());
            System.out.println("-------");
            return (List)MapperExecuter.getMapperExecute(this.conditionSign.getJoinEntityClass(), (SFunction & Serializable)mapper -> mapper.selectList((Wrapper)queryWrapper));
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private <MID> List<MID> listMidData(MidConditionDescription midConditionDescription) {
        ArrayList<Object> selfFieldVals = new ArrayList<Object>();
        try {
            for (BEAN bean : this.beans) {
                selfFieldVals.add(midConditionDescription.getSelfFieldGetMethod().invoke(bean, new Object[0]));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (selfFieldVals.isEmpty()) {
            return Collections.emptyList();
        }
        List selfFieldValList = CollectionSplitter.splitList(selfFieldVals, 500);
        return selfFieldValList.parallelStream().map(selfFieldValues -> {
            QueryWrapper queryWrapper = new QueryWrapper();
            String selfMidColumnName = midConditionDescription.getSelfMidColumnName();
            queryWrapper.in((Object)selfMidColumnName, (Collection)selfFieldValues);
            if (StringUtils.hasText((String)midConditionDescription.getCustomCondition())) {
                queryWrapper.apply(midConditionDescription.getCustomCondition(), new Object[0]);
            }
            Class<?> entity = midConditionDescription.getMidEntity();
            return (List)MapperExecuter.getMapperExecute(entity, (SFunction & Serializable)mapper -> mapper.selectList((Wrapper)queryWrapper));
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void fullDataToBeanField(BEAN bean, FieldDescription<?, MidConditionDescription> fieldAnnotation, List<?> dataList) {
        List<?> val;
        if (fieldAnnotation.isCollection()) {
            val = dataList;
        } else {
            this.checkBindDataSize(bean.getClass().getName(), dataList.size(), fieldAnnotation.getFieldName());
            val = dataList.isEmpty() ? null : dataList.get(0);
        }
        try {
            fieldAnnotation.getSetMethod().invoke(bean, val);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void checkBindDataSize(String beanName, int dataListSize, String fieldName) {
        if (dataListSize > 1) {
            String entityName = this.conditionSign.getJoinEntityClass().getName();
            throw new RuntimeException(beanName + "." + fieldName + "\u5173\u8054" + entityName + "\u7684\u6570\u636e\u6761\u6570\u5927\u4e8e1\u6761");
        }
    }

    private String getSelfFieldValFromBean(MidConditionDescription midConditionDescription, BEAN bean) {
        try {
            Object val = midConditionDescription.getSelfFieldGetMethod().invoke(bean, new Object[0]);
            return Optional.ofNullable(val).map(Object::toString).orElse("");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ByMidResultBuilder(List<BEAN> beans, FieldDescription.ConditionSign<ENTITY, MidConditionDescription> conditionSign, List<? extends FieldDescription<?, MidConditionDescription>> fieldDescriptions, FillDataCallback fillDataCallback) {
        this.beans = beans;
        this.conditionSign = conditionSign;
        this.fieldDescriptions = fieldDescriptions;
        this.fillDataCallback = fillDataCallback;
    }

    public static <BEAN, ENTITY> ByMidResultBuilder<BEAN, ENTITY> newInstance(List<BEAN> beans, FieldDescription.ConditionSign<ENTITY, MidConditionDescription> conditionSign, List<? extends FieldDescription<?, MidConditionDescription>> fieldDescriptions, FillDataCallback fillDataCallback) {
        return new ByMidResultBuilder<BEAN, ENTITY>(beans, conditionSign, fieldDescriptions, fillDataCallback);
    }

    public static interface FillDataCallback {
        default public String[] selectColumns(List<?> beans, FieldDescription.ConditionSign<?, MidConditionDescription> conditionSign, List<? extends FieldDescription<?, MidConditionDescription>> fieldAnnotationList) {
            return null;
        }

        default public void fillBefore(Object bean, FieldDescription<?, MidConditionDescription> fieldAnnotation, List<?> entities) {
        }

        default public List<?> changeDataList(Object bean, FieldDescription<?, MidConditionDescription> fieldAnnotation, List<?> entities) {
            return entities;
        }
    }
}

