/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mpe.bind.builder;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.dromara.mpe.bind.metadata.JoinConditionDescription;
import org.dromara.mpe.bind.metadata.OrderByDescription;
import org.springframework.util.StringUtils;

public class QueryWrapperBuilder<ENTITY> {
    private final QueryWrapper<ENTITY> queryWrapper = new QueryWrapper();
    private List<JoinConditionDescription> conditions;
    private String customCondition;
    private String last;

    public QueryWrapperBuilder<ENTITY> select(String[] selectColumns) {
        if (selectColumns != null && selectColumns.length > 0) {
            this.queryWrapper.select((Object[])selectColumns);
        }
        return this;
    }

    public QueryWrapperBuilder<ENTITY> where(@NonNull List<JoinConditionDescription> conditions, String customCondition) {
        if (conditions == null) {
            throw new NullPointerException("conditions is marked non-null but is null");
        }
        this.conditions = conditions;
        this.customCondition = customCondition;
        return this;
    }

    public QueryWrapperBuilder<ENTITY> orderBy(List<OrderByDescription> orderBys) {
        for (OrderByDescription orderBy : orderBys) {
            this.queryWrapper.orderBy(true, orderBy.isAsc(), (Object)orderBy.getColumnName());
        }
        return this;
    }

    public QueryWrapperBuilder<ENTITY> last(String last) {
        this.last = last;
        return this;
    }

    public QueryWrapper<ENTITY> build(List<Where> wheres) {
        if (!StringUtils.hasText((String)this.customCondition)) {
            this.joinCondition(this.queryWrapper, wheres);
        } else {
            Map<String, List<Where>> whereMap = wheres.stream().collect(Collectors.groupingBy(Where::getCustomCondition));
            for (Map.Entry<String, List<Where>> whereEntry : whereMap.entrySet()) {
                String customCondition = whereEntry.getKey();
                List<Where> whereList = whereEntry.getValue();
                this.queryWrapper.or(queryWrapper3 -> {
                    queryWrapper3.apply(customCondition, new Object[0]);
                    this.joinCondition((QueryWrapper<ENTITY>)queryWrapper3, (Collection<Where>)whereList);
                });
            }
        }
        if (StringUtils.hasText((String)this.last)) {
            this.queryWrapper.last(this.last);
        }
        return this.queryWrapper;
    }

    private void joinCondition(QueryWrapper<ENTITY> queryWrapper, Collection<Where> wheres) {
        if (this.conditions.size() == 1) {
            List whereItemList = wheres.stream().map(Where::getWhereItems).flatMap(Collection::stream).collect(Collectors.toList());
            String column = ((WhereItem)whereItemList.get(0)).column;
            List values = whereItemList.stream().map(WhereItem::getValue).collect(Collectors.toList());
            if (values.size() > 1) {
                queryWrapper.in((Object)column, values);
            } else {
                queryWrapper.eq((Object)column, values.get(0));
            }
        } else {
            queryWrapper.and(queryWrapper2 -> {
                for (Where where : wheres) {
                    queryWrapper2.or(qw -> {
                        for (WhereItem whereItem : where.whereItems) {
                            qw.eq((Object)whereItem.column, whereItem.value);
                        }
                    });
                }
            });
        }
    }

    private QueryWrapperBuilder() {
    }

    public static <ENTITY> QueryWrapperBuilder<ENTITY> newInstance() {
        return new QueryWrapperBuilder<ENTITY>();
    }

    public static class WhereItem {
        private final String column;
        private final Object value;

        public String getColumn() {
            return this.column;
        }

        public Object getValue() {
            return this.value;
        }

        public WhereItem(String column, Object value) {
            this.column = column;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WhereItem)) {
                return false;
            }
            WhereItem other = (WhereItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$column = this.getColumn();
            String other$column = other.getColumn();
            if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WhereItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $column = this.getColumn();
            result = result * 59 + ($column == null ? 43 : $column.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }

    public static class Where {
        private final List<WhereItem> whereItems;
        private final String customCondition;

        public List<WhereItem> getWhereItems() {
            return this.whereItems;
        }

        public String getCustomCondition() {
            return this.customCondition;
        }

        public Where(List<WhereItem> whereItems, String customCondition) {
            this.whereItems = whereItems;
            this.customCondition = customCondition;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Where)) {
                return false;
            }
            Where other = (Where)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<WhereItem> this$whereItems = this.getWhereItems();
            List<WhereItem> other$whereItems = other.getWhereItems();
            if (this$whereItems == null ? other$whereItems != null : !((Object)this$whereItems).equals(other$whereItems)) {
                return false;
            }
            String this$customCondition = this.getCustomCondition();
            String other$customCondition = other.getCustomCondition();
            return !(this$customCondition == null ? other$customCondition != null : !this$customCondition.equals(other$customCondition));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Where;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<WhereItem> $whereItems = this.getWhereItems();
            result = result * 59 + ($whereItems == null ? 43 : ((Object)$whereItems).hashCode());
            String $customCondition = this.getCustomCondition();
            result = result * 59 + ($customCondition == null ? 43 : $customCondition.hashCode());
            return result;
        }
    }
}

