/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mpe.bind.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.dromara.mpe.bind.metadata.JoinConditionDescription;
import org.dromara.mpe.bind.metadata.annotation.AggFuncField;
import org.dromara.mpe.bind.metadata.annotation.BindAggFunc;
import org.dromara.mpe.bind.metadata.enums.AggFuncEnum;
import org.dromara.mpe.magic.util.BeanClassUtil;
import org.dromara.mpe.magic.util.TableColumnNameUtil;
import org.springframework.util.StringUtils;

public class BindAggFuncDescription {
    private final Field field;
    private final Class<?> fieldClass;
    private final Method setMethod;
    private final BindAggFunc bindAnnotation;
    private final Class<?> entityClass;
    private final String customCondition;
    private final List<JoinConditionDescription> conditions;
    private final AggFuncEnum aggFunc;
    private final String aggColumnRealName;

    public BindAggFuncDescription(Field field, Method setMethod, BindAggFunc bindFunction, Class<?> entityClass, List<JoinConditionDescription> conditions) {
        this.field = field;
        this.fieldClass = BeanClassUtil.getFieldRealClass((Field)field);
        this.setMethod = setMethod;
        this.bindAnnotation = bindFunction;
        this.entityClass = entityClass;
        this.customCondition = bindFunction.customCondition();
        this.conditions = conditions.stream().distinct().collect(Collectors.toList());
        AggFuncField aggFuncField = bindFunction.aggField();
        this.aggFunc = aggFuncField.func();
        this.aggColumnRealName = StringUtils.hasText((String)aggFuncField.field()) ? TableColumnNameUtil.getColumnName(entityClass, (String)aggFuncField.field()) : aggFuncField.field();
    }

    public static ConditionSign groupBy(BindAggFuncDescription description) {
        return new ConditionSign(description.getEntityClass(), description.getCustomCondition(), description.getConditions(), description.getAggFunc(), description.getAggColumnRealName());
    }

    public Field getField() {
        return this.field;
    }

    public Class<?> getFieldClass() {
        return this.fieldClass;
    }

    public Method getSetMethod() {
        return this.setMethod;
    }

    public BindAggFunc getBindAnnotation() {
        return this.bindAnnotation;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public String getCustomCondition() {
        return this.customCondition;
    }

    public List<JoinConditionDescription> getConditions() {
        return this.conditions;
    }

    public AggFuncEnum getAggFunc() {
        return this.aggFunc;
    }

    public String getAggColumnRealName() {
        return this.aggColumnRealName;
    }

    public static class ConditionSign {
        private Class<?> entityClass;
        private String customCondition;
        private List<JoinConditionDescription> conditions;
        private AggFuncEnum aggFunc;
        private String aggColumnRealName;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConditionSign that = (ConditionSign)o;
            String thisConditions = this.getSortConditionStr();
            String thatConditions = that.getSortConditionStr();
            return this.entityClass.equals(that.entityClass) && thisConditions.equals(thatConditions) && this.customCondition.equals(that.customCondition) && this.aggFunc.equals((Object)that.aggFunc) && this.aggColumnRealName.equals(that.aggColumnRealName);
        }

        public int hashCode() {
            return Objects.hash(this.entityClass, this.getSortConditionStr(), this.customCondition, this.aggFunc, this.aggColumnRealName);
        }

        private String getSortConditionStr() {
            return this.conditions.stream().map(Object::toString).sorted().collect(Collectors.joining("#"));
        }

        public Class<?> getEntityClass() {
            return this.entityClass;
        }

        public String getCustomCondition() {
            return this.customCondition;
        }

        public List<JoinConditionDescription> getConditions() {
            return this.conditions;
        }

        public AggFuncEnum getAggFunc() {
            return this.aggFunc;
        }

        public String getAggColumnRealName() {
            return this.aggColumnRealName;
        }

        public void setEntityClass(Class<?> entityClass) {
            this.entityClass = entityClass;
        }

        public void setCustomCondition(String customCondition) {
            this.customCondition = customCondition;
        }

        public void setConditions(List<JoinConditionDescription> conditions) {
            this.conditions = conditions;
        }

        public void setAggFunc(AggFuncEnum aggFunc) {
            this.aggFunc = aggFunc;
        }

        public void setAggColumnRealName(String aggColumnRealName) {
            this.aggColumnRealName = aggColumnRealName;
        }

        public String toString() {
            return "BindAggFuncDescription.ConditionSign(entityClass=" + this.getEntityClass() + ", customCondition=" + this.getCustomCondition() + ", conditions=" + this.getConditions() + ", aggFunc=" + this.getAggFunc() + ", aggColumnRealName=" + this.getAggColumnRealName() + ")";
        }

        public ConditionSign(Class<?> entityClass, String customCondition, List<JoinConditionDescription> conditions, AggFuncEnum aggFunc, String aggColumnRealName) {
            this.entityClass = entityClass;
            this.customCondition = customCondition;
            this.conditions = conditions;
            this.aggFunc = aggFunc;
            this.aggColumnRealName = aggColumnRealName;
        }

        public ConditionSign() {
        }
    }
}

