/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mpe.bind.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import org.dromara.mpe.magic.util.TableColumnNameUtil;

public class JoinConditionDescription {
    protected final Field selfField;
    protected final Field joinField;
    protected final Method selfFieldGetMethod;
    protected final Method joinFieldGetMethod;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinConditionDescription condition = (JoinConditionDescription)o;
        return this.getSelfFieldName().equals(condition.getSelfFieldName()) && this.getJoinFieldName().equals(condition.getJoinFieldName());
    }

    public int hashCode() {
        return Objects.hash(this.getSelfFieldName(), this.getJoinFieldName());
    }

    public String toString() {
        return this.getSelfFieldName() + "|" + this.getJoinFieldName();
    }

    public String getSelfFieldName() {
        return this.selfField.getName();
    }

    public String getJoinFieldName() {
        return this.joinField.getName();
    }

    public String getSelfColumnName() {
        return TableColumnNameUtil.getColumnName((Field)this.selfField);
    }

    public String getJoinColumnName() {
        return TableColumnNameUtil.getColumnName((Field)this.joinField);
    }

    public Field getSelfField() {
        return this.selfField;
    }

    public Field getJoinField() {
        return this.joinField;
    }

    public Method getSelfFieldGetMethod() {
        return this.selfFieldGetMethod;
    }

    public Method getJoinFieldGetMethod() {
        return this.joinFieldGetMethod;
    }

    public JoinConditionDescription(Field selfField, Field joinField, Method selfFieldGetMethod, Method joinFieldGetMethod) {
        this.selfField = selfField;
        this.joinField = joinField;
        this.selfFieldGetMethod = selfFieldGetMethod;
        this.joinFieldGetMethod = joinFieldGetMethod;
    }
}

