/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mpe.bind;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dromara.mpe.bind.binder.BindAggFuncBinder;
import org.dromara.mpe.bind.binder.BindEntityBinder;
import org.dromara.mpe.bind.binder.BindEntityByMidBinder;
import org.dromara.mpe.bind.binder.BindFieldBinder;
import org.dromara.mpe.bind.binder.BindFieldByMidBinder;
import org.dromara.mpe.bind.manager.BeanAnnotationManager;
import org.dromara.mpe.bind.metadata.BeanDescription;
import org.dromara.mpe.magic.util.BeanClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class Binder {
    private static final Logger log = LoggerFactory.getLogger(Binder.class);

    @SafeVarargs
    public static <BEAN> void bindOn(BEAN bean, SFunction<BEAN, ?> firstField, SFunction<BEAN, ?> ... otherFields) {
        if (bean == null) {
            return;
        }
        Binder.bindOn(Collections.singletonList(bean), firstField, otherFields);
    }

    @SafeVarargs
    public static <BEAN> void bindOn(IPage<BEAN> bean, SFunction<BEAN, ?> firstField, SFunction<BEAN, ?> ... otherFields) {
        Binder.bindOn(bean.getRecords(), firstField, otherFields);
    }

    @SafeVarargs
    public static <BEAN> void bindOn(List<BEAN> beans, SFunction<BEAN, ?> firstField, SFunction<BEAN, ?> ... otherFields) {
        ArrayList bindFields = new ArrayList();
        bindFields.add(firstField);
        if (otherFields != null) {
            bindFields.addAll(Arrays.asList(otherFields));
        }
        Binder.bindOn(beans, bindFields);
    }

    public static <BEAN> void bindOn(BEAN bean, List<SFunction<BEAN, ?>> bindFields) {
        if (bean == null) {
            return;
        }
        Binder.bindOn(Collections.singletonList(bean), bindFields);
    }

    public static <BEAN> void bindOn(IPage<BEAN> bean, List<SFunction<BEAN, ?>> bindFields) {
        Binder.bindOn(bean.getRecords(), bindFields);
    }

    public static <BEAN> void bindOn(List<BEAN> beans, List<SFunction<BEAN, ?>> bindFields) {
        ArrayList<String> bindFieldNames = new ArrayList<String>();
        if (bindFields != null) {
            for (SFunction<BEAN, ?> otherFieldSF : bindFields) {
                bindFieldNames.add(BeanClassUtil.getFieldName(otherFieldSF));
            }
        }
        Binder.bind(beans, bindFieldNames, Collections.emptyList());
    }

    public static <BEAN> void bind(BEAN bean) {
        if (bean == null) {
            return;
        }
        Binder.bind(Collections.singletonList(bean));
    }

    public static <BEAN> void bind(IPage<BEAN> page) {
        if (page == null) {
            return;
        }
        Binder.bind(page.getRecords());
    }

    public static <BEAN> void bind(List<BEAN> beans) {
        if (beans == null) {
            return;
        }
        Binder.bind(beans, Collections.emptyList(), Collections.emptyList());
    }

    public static <BEAN> void bind(List<BEAN> beans, List<String> includeField, List<String> ignoreField) {
        if (CollectionUtils.isEmpty(beans)) {
            return;
        }
        Class<?> beanClass = beans.get(0).getClass();
        BeanDescription<?> beanAnnotation = BeanAnnotationManager.getBeanAnnotation(beanClass, includeField, ignoreField);
        if (beanAnnotation.isValid()) {
            BindAggFuncBinder.newInstance().doBind(beans, beanAnnotation.getBindAggFuncAnnotations());
            BindFieldBinder.newInstance().doBind(beans, beanAnnotation.getBindFieldAnnotations());
            BindEntityBinder.newInstance().doBind(beans, beanAnnotation.getBindEntityAnnotations());
            BindFieldByMidBinder.newInstance().doBind(beans, beanAnnotation.getBindFieldByMidDescriptions());
            BindEntityByMidBinder.newInstance().doBind(beans, beanAnnotation.getBindEntityByMidAnnotations());
        }
    }
}

