/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mpe.bind.binder;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.dromara.mpe.bind.binder.IBinder;
import org.dromara.mpe.bind.builder.ResultBuilder;
import org.dromara.mpe.bind.metadata.BindFieldDescription;
import org.dromara.mpe.bind.metadata.FieldDescription;
import org.dromara.mpe.bind.metadata.JoinConditionDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindFieldBinder<BEAN>
implements IBinder<BEAN, BindFieldDescription, JoinConditionDescription> {
    private static final Logger log = LoggerFactory.getLogger(BindFieldBinder.class);

    @Override
    public <ENTITY> void fillData(List<BEAN> beans, FieldDescription.ConditionSign<ENTITY, JoinConditionDescription> conditionSign, final List<BindFieldDescription> bindFieldDescriptions) {
        ResultBuilder.FillDataCallback fillDataCallback = new ResultBuilder.FillDataCallback(){

            @Override
            public String[] selectColumns(List<?> beans, FieldDescription.ConditionSign<?, JoinConditionDescription> entityJoinCondition, List<? extends FieldDescription<?, JoinConditionDescription>> fieldAnnotationList) {
                Set<String> columns = bindFieldDescriptions.stream().map(BindFieldDescription::getRealColumnName).collect(Collectors.toSet());
                for (JoinConditionDescription condition : entityJoinCondition.getConditions()) {
                    columns.add(condition.getJoinColumnName());
                }
                return columns.toArray(new String[0]);
            }

            @Override
            public List<?> changeDataList(Object bean, FieldDescription<?, JoinConditionDescription> fieldAnnotation, List<?> entities) {
                return entities.stream().map(entity -> {
                    try {
                        return ((BindFieldDescription)fieldAnnotation).getBindFieldGetMethod().invoke(entity, new Object[0]);
                    }
                    catch (Exception e) {
                        log.error("\u7ed1\u5b9a\u5c5e\u6027\u83b7\u53d6\u503c\u5931\u8d25", (Throwable)e);
                        return null;
                    }
                }).collect(Collectors.toList());
            }
        };
        ResultBuilder.newInstance(beans, conditionSign, bindFieldDescriptions, fillDataCallback).fillData();
    }

    private BindFieldBinder() {
    }

    public static <BEAN> BindFieldBinder<BEAN> newInstance() {
        return new BindFieldBinder<BEAN>();
    }
}

