/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mpe.bind.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dromara.mpe.bind.metadata.BindAggFuncDescription;
import org.dromara.mpe.bind.metadata.BindEntityByMidDescription;
import org.dromara.mpe.bind.metadata.BindEntityDescription;
import org.dromara.mpe.bind.metadata.BindFieldByMidDescription;
import org.dromara.mpe.bind.metadata.BindFieldDescription;
import org.dromara.mpe.bind.metadata.annotation.BindAggFunc;
import org.dromara.mpe.bind.metadata.annotation.BindEntity;
import org.dromara.mpe.bind.metadata.annotation.BindEntityByMid;
import org.dromara.mpe.bind.metadata.annotation.BindField;
import org.dromara.mpe.bind.metadata.annotation.BindFieldByMid;
import org.dromara.mpe.bind.metadata.annotation.JoinCondition;
import org.dromara.mpe.bind.metadata.builder.FieldDescriptionBuilder;
import org.dromara.mpe.magic.util.AnnotatedElementUtilsPlus;
import org.dromara.mpe.magic.util.AnnotationDefaultValueHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanDescription<BEAN> {
    private static final Logger log = LoggerFactory.getLogger(BeanDescription.class);
    private final Class<BEAN> beanClass;
    private final List<BindAggFuncDescription> bindAggFuncAnnotations = new ArrayList<BindAggFuncDescription>();
    private final List<BindFieldDescription> bindFieldAnnotations = new ArrayList<BindFieldDescription>();
    private final List<BindEntityDescription> bindEntityAnnotations = new ArrayList<BindEntityDescription>();
    private final List<BindFieldByMidDescription> bindFieldByMidDescriptions = new ArrayList<BindFieldByMidDescription>();
    private final List<BindEntityByMidDescription> bindEntityByMidAnnotations = new ArrayList<BindEntityByMidDescription>();

    public BeanDescription(Class<BEAN> beanClass) {
        this.beanClass = beanClass;
    }

    public void findBindAnnotation(Field field) {
        BindAggFunc bindAggFunc = (BindAggFunc)AnnotatedElementUtilsPlus.findDeepMergedAnnotation((AnnotatedElement)field, BindAggFunc.class);
        if (bindAggFunc != null) {
            bindAggFunc = BeanDescription.extractedSingleCondition(field, bindAggFunc, BindAggFunc.class);
            BindAggFuncDescription fieldDescription = FieldDescriptionBuilder.build(this.beanClass, field, bindAggFunc);
            this.bindAggFuncAnnotations.add(fieldDescription);
            return;
        }
        BindField bindField = (BindField)AnnotatedElementUtilsPlus.findDeepMergedAnnotation((AnnotatedElement)field, BindField.class);
        if (bindField != null) {
            bindField = BeanDescription.extractedSingleCondition(field, bindField, BindField.class);
            BindFieldDescription fieldDescription = FieldDescriptionBuilder.build(this.beanClass, field, bindField);
            this.bindFieldAnnotations.add(fieldDescription);
            return;
        }
        BindEntity bindEntity = (BindEntity)AnnotatedElementUtilsPlus.findDeepMergedAnnotation((AnnotatedElement)field, BindEntity.class);
        if (bindEntity != null) {
            bindEntity = BeanDescription.extractedSingleCondition(field, bindEntity, BindEntity.class);
            BindEntityDescription fieldDescription = FieldDescriptionBuilder.build(this.beanClass, field, bindEntity);
            this.bindEntityAnnotations.add(fieldDescription);
            return;
        }
        BindFieldByMid bindFieldByMid = (BindFieldByMid)AnnotatedElementUtilsPlus.findDeepMergedAnnotation((AnnotatedElement)field, BindFieldByMid.class);
        if (bindFieldByMid != null) {
            BindFieldByMidDescription fieldDescription = FieldDescriptionBuilder.build(this.beanClass, field, bindFieldByMid);
            this.bindFieldByMidDescriptions.add(fieldDescription);
            return;
        }
        BindEntityByMid bindEntityByMid = (BindEntityByMid)AnnotatedElementUtilsPlus.findDeepMergedAnnotation((AnnotatedElement)field, BindEntityByMid.class);
        if (bindEntityByMid != null) {
            BindEntityByMidDescription fieldDescription = FieldDescriptionBuilder.build(this.beanClass, field, bindEntityByMid);
            this.bindEntityByMidAnnotations.add(fieldDescription);
            return;
        }
        log.debug("\u5b57\u6bb5{}\u6ca1\u6709Bind\u6ce8\u89e3", (Object)field.getName());
    }

    private static <A extends Annotation> A extractedSingleCondition(Field field, A annotation, Class<A> annotationClass) {
        JoinCondition joinCondition = (JoinCondition)AnnotatedElementUtilsPlus.findDeepMergedAnnotation((AnnotatedElement)field, JoinCondition.class);
        if (joinCondition != null) {
            HashMap<String, JoinCondition[]> values = new HashMap<String, JoinCondition[]>();
            values.put("conditions", new JoinCondition[]{joinCondition});
            return (A)AnnotationDefaultValueHelper.updateAnnotationInstance(annotation, annotationClass, values);
        }
        return annotation;
    }

    public boolean isValid() {
        return !this.bindAggFuncAnnotations.isEmpty() || !this.bindFieldAnnotations.isEmpty() || !this.bindEntityAnnotations.isEmpty() || !this.bindFieldByMidDescriptions.isEmpty() || !this.bindEntityByMidAnnotations.isEmpty();
    }

    public Class<BEAN> getBeanClass() {
        return this.beanClass;
    }

    public List<BindAggFuncDescription> getBindAggFuncAnnotations() {
        return this.bindAggFuncAnnotations;
    }

    public List<BindFieldDescription> getBindFieldAnnotations() {
        return this.bindFieldAnnotations;
    }

    public List<BindEntityDescription> getBindEntityAnnotations() {
        return this.bindEntityAnnotations;
    }

    public List<BindFieldByMidDescription> getBindFieldByMidDescriptions() {
        return this.bindFieldByMidDescriptions;
    }

    public List<BindEntityByMidDescription> getBindEntityByMidAnnotations() {
        return this.bindEntityByMidAnnotations;
    }
}

