/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.myth.jms.service;

import java.util.Objects;
import javax.jms.Destination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.dromara.myth.annotation.MessageTypeEnum;
import org.dromara.myth.core.service.MythMqSendService;
import org.springframework.jms.core.JmsTemplate;

public class ActivemqSendServiceImpl
implements MythMqSendService {
    private JmsTemplate jmsTemplate;

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void sendMessage(String destination, Integer pattern, byte[] message) {
        ActiveMQQueue queue = new ActiveMQQueue(destination);
        if (Objects.equals(MessageTypeEnum.P2P.getCode(), pattern)) {
            queue = new ActiveMQQueue(destination);
        } else if (Objects.equals(MessageTypeEnum.TOPIC.getCode(), pattern)) {
            queue = new ActiveMQTopic(destination);
        }
        this.jmsTemplate.convertAndSend((Destination)queue, (Object)message);
    }
}

