/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.myth.motan.filter;

import com.weibo.api.motan.core.extension.Activation;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.filter.Filter;
import com.weibo.api.motan.rpc.Caller;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.util.ReflectUtil;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.stream.Stream;
import org.dromara.myth.annotation.Myth;
import org.dromara.myth.common.bean.context.MythTransactionContext;
import org.dromara.myth.common.bean.entity.MythInvocation;
import org.dromara.myth.common.bean.entity.MythParticipant;
import org.dromara.myth.common.exception.MythRuntimeException;
import org.dromara.myth.core.concurrent.threadlocal.TransactionContextLocal;
import org.dromara.myth.core.helper.SpringBeanUtils;
import org.dromara.myth.core.mediator.RpcMediator;
import org.dromara.myth.core.service.engine.MythTransactionEngine;

@SpiMeta(name="motanMythTransactionFilter")
@Activation(key={"referer"})
public class MotanMythTransactionFilter
implements Filter {
    public Response filter(Caller<?> caller, Request request) {
        String interfaceName = request.getInterfaceName();
        String methodName = request.getMethodName();
        Object[] arguments = request.getArguments();
        Class[] args = null;
        Method method = null;
        Myth myth = null;
        Class clazz = null;
        try {
            clazz = ReflectUtil.forName((String)interfaceName);
            Method[] methods = clazz.getMethods();
            args = Stream.of(methods).filter(m -> m.getName().equals(methodName)).findFirst().map(Method::getParameterTypes).get();
            method = clazz.getDeclaredMethod(methodName, args);
            myth = method.getAnnotation(Myth.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Objects.nonNull(myth)) {
            MythParticipant participant;
            MythTransactionContext mythTransactionContext = TransactionContextLocal.getInstance().get();
            if (Objects.nonNull(mythTransactionContext)) {
                RpcMediator.getInstance().transmit((arg_0, arg_1) -> ((Request)request).setAttachment(arg_0, arg_1), mythTransactionContext);
            }
            if (Objects.nonNull(participant = this.buildParticipant(mythTransactionContext, myth, method, clazz, arguments, args))) {
                ((MythTransactionEngine)SpringBeanUtils.getInstance().getBean(MythTransactionEngine.class)).registerParticipant(participant);
            }
            try {
                return caller.call(request);
            }
            catch (Exception e) {
                e.printStackTrace();
                return new DefaultResponse();
            }
        }
        return caller.call(request);
    }

    private MythParticipant buildParticipant(MythTransactionContext mythTransactionContext, Myth myth, Method method, Class clazz, Object[] arguments, Class ... args) throws MythRuntimeException {
        if (Objects.nonNull(mythTransactionContext)) {
            if (Objects.isNull(method) || Objects.isNull(clazz)) {
                return null;
            }
            MythInvocation mythInvocation = new MythInvocation(clazz, method.getName(), args, arguments);
            String destination = myth.destination();
            Integer pattern = myth.pattern().getCode();
            return new MythParticipant(mythTransactionContext.getTransId(), destination, pattern, mythInvocation);
        }
        return null;
    }
}

