/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.model;

import java.util.Arrays;

public class ModuleDealRecord {
    private String moduleName;
    private String moduleAccountId;
    private String contractName;
    private double dealProfit;
    private byte[] openTrade;
    private byte[] closeTrade;

    public static ModuleDealRecordBuilder builder() {
        return new ModuleDealRecordBuilder();
    }

    public ModuleDealRecord(String moduleName, String moduleAccountId, String contractName, double dealProfit, byte[] openTrade, byte[] closeTrade) {
        this.moduleName = moduleName;
        this.moduleAccountId = moduleAccountId;
        this.contractName = contractName;
        this.dealProfit = dealProfit;
        this.openTrade = openTrade;
        this.closeTrade = closeTrade;
    }

    public ModuleDealRecord() {
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getModuleAccountId() {
        return this.moduleAccountId;
    }

    public String getContractName() {
        return this.contractName;
    }

    public double getDealProfit() {
        return this.dealProfit;
    }

    public byte[] getOpenTrade() {
        return this.openTrade;
    }

    public byte[] getCloseTrade() {
        return this.closeTrade;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setModuleAccountId(String moduleAccountId) {
        this.moduleAccountId = moduleAccountId;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public void setDealProfit(double dealProfit) {
        this.dealProfit = dealProfit;
    }

    public void setOpenTrade(byte[] openTrade) {
        this.openTrade = openTrade;
    }

    public void setCloseTrade(byte[] closeTrade) {
        this.closeTrade = closeTrade;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModuleDealRecord)) {
            return false;
        }
        ModuleDealRecord other = (ModuleDealRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getDealProfit(), other.getDealProfit()) != 0) {
            return false;
        }
        String this$moduleName = this.getModuleName();
        String other$moduleName = other.getModuleName();
        if (this$moduleName == null ? other$moduleName != null : !this$moduleName.equals(other$moduleName)) {
            return false;
        }
        String this$moduleAccountId = this.getModuleAccountId();
        String other$moduleAccountId = other.getModuleAccountId();
        if (this$moduleAccountId == null ? other$moduleAccountId != null : !this$moduleAccountId.equals(other$moduleAccountId)) {
            return false;
        }
        String this$contractName = this.getContractName();
        String other$contractName = other.getContractName();
        if (this$contractName == null ? other$contractName != null : !this$contractName.equals(other$contractName)) {
            return false;
        }
        if (!Arrays.equals(this.getOpenTrade(), other.getOpenTrade())) {
            return false;
        }
        return Arrays.equals(this.getCloseTrade(), other.getCloseTrade());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModuleDealRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $dealProfit = Double.doubleToLongBits(this.getDealProfit());
        result = result * 59 + (int)($dealProfit ^ $dealProfit >>> 32);
        String $moduleName = this.getModuleName();
        result = result * 59 + ($moduleName == null ? 43 : $moduleName.hashCode());
        String $moduleAccountId = this.getModuleAccountId();
        result = result * 59 + ($moduleAccountId == null ? 43 : $moduleAccountId.hashCode());
        String $contractName = this.getContractName();
        result = result * 59 + ($contractName == null ? 43 : $contractName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getOpenTrade());
        result = result * 59 + Arrays.hashCode(this.getCloseTrade());
        return result;
    }

    public String toString() {
        return "ModuleDealRecord(moduleName=" + this.getModuleName() + ", moduleAccountId=" + this.getModuleAccountId() + ", contractName=" + this.getContractName() + ", dealProfit=" + this.getDealProfit() + ", openTrade=" + Arrays.toString(this.getOpenTrade()) + ", closeTrade=" + Arrays.toString(this.getCloseTrade()) + ")";
    }

    public static class ModuleDealRecordBuilder {
        private String moduleName;
        private String moduleAccountId;
        private String contractName;
        private double dealProfit;
        private byte[] openTrade;
        private byte[] closeTrade;

        ModuleDealRecordBuilder() {
        }

        public ModuleDealRecordBuilder moduleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public ModuleDealRecordBuilder moduleAccountId(String moduleAccountId) {
            this.moduleAccountId = moduleAccountId;
            return this;
        }

        public ModuleDealRecordBuilder contractName(String contractName) {
            this.contractName = contractName;
            return this;
        }

        public ModuleDealRecordBuilder dealProfit(double dealProfit) {
            this.dealProfit = dealProfit;
            return this;
        }

        public ModuleDealRecordBuilder openTrade(byte[] openTrade) {
            this.openTrade = openTrade;
            return this;
        }

        public ModuleDealRecordBuilder closeTrade(byte[] closeTrade) {
            this.closeTrade = closeTrade;
            return this;
        }

        public ModuleDealRecord build() {
            return new ModuleDealRecord(this.moduleName, this.moduleAccountId, this.contractName, this.dealProfit, this.openTrade, this.closeTrade);
        }

        public String toString() {
            return "ModuleDealRecord.ModuleDealRecordBuilder(moduleName=" + this.moduleName + ", moduleAccountId=" + this.moduleAccountId + ", contractName=" + this.contractName + ", dealProfit=" + this.dealProfit + ", openTrade=" + Arrays.toString(this.openTrade) + ", closeTrade=" + Arrays.toString(this.closeTrade) + ")";
        }
    }
}

