/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.model;

public class TimeSeriesValue
implements Comparable<TimeSeriesValue> {
    private double value;
    private long timestamp;
    private boolean unsettled;

    public TimeSeriesValue(double value, long timestamp) {
        this.value = value;
        this.timestamp = timestamp;
    }

    public TimeSeriesValue(double value, long timestamp, boolean unsettled) {
        this.value = value;
        this.timestamp = timestamp;
        this.unsettled = unsettled;
    }

    @Override
    public int compareTo(TimeSeriesValue o) {
        return this.timestamp < o.timestamp ? -1 : 1;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeSeriesValue)) {
            return false;
        }
        TimeSeriesValue other = (TimeSeriesValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getValue(), other.getValue()) != 0) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        return this.isUnsettled() == other.isUnsettled();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimeSeriesValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value ^ $value >>> 32);
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp ^ $timestamp >>> 32);
        result = result * 59 + (this.isUnsettled() ? 79 : 97);
        return result;
    }

    public double getValue() {
        return this.value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isUnsettled() {
        return this.unsettled;
    }
}

