/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.utils;

import cn.hutool.core.date.LocalDateTimeUtil;
import java.time.LocalDate;
import java.time.temporal.TemporalAccessor;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dromara.northstar.common.constant.DateTimeConstant;
import xyz.redtorch.pb.CoreEnum;
import xyz.redtorch.pb.CoreField;

public class BarUtils {
    public static List<CoreField.BarField> mergeWeeklyBar(List<CoreField.BarField> srcBarList) {
        LinkedList<CoreField.BarField.Builder> resultList = new LinkedList<CoreField.BarField.Builder>();
        String yearlyWeek = null;
        for (CoreField.BarField bar : srcBarList) {
            LocalDate date = LocalDate.parse(bar.getTradingDay(), DateTimeConstant.D_FORMAT_INT_FORMATTER);
            String yearlyWeekOfDate = String.format("%d%d", date.getYear(), LocalDateTimeUtil.weekOfYear((TemporalAccessor)date));
            if (!StringUtils.equals((CharSequence)yearlyWeekOfDate, yearlyWeek)) {
                BarUtils.doCalculateDelta(resultList);
                resultList.add(CoreField.BarField.newBuilder(bar));
                yearlyWeek = yearlyWeekOfDate;
                continue;
            }
            CoreField.BarField.Builder lastBar = resultList.peekLast();
            lastBar.setTradingDay(bar.getTradingDay());
            lastBar.setActionDay(bar.getActionDay());
            lastBar.setActionTime(bar.getActionTime());
            lastBar.setActionTimestamp(bar.getActionTimestamp());
            lastBar.setHighPrice(Math.max(lastBar.getHighPrice(), bar.getHighPrice()));
            lastBar.setLowPrice(Math.min(lastBar.getLowPrice(), bar.getLowPrice()));
            lastBar.setClosePrice(bar.getClosePrice());
            lastBar.setVolume(lastBar.getVolume() + bar.getVolume());
            lastBar.setTurnover(lastBar.getTurnover() + bar.getTurnover());
            lastBar.setNumTrades(lastBar.getNumTrades() + bar.getNumTrades());
            lastBar.setOpenInterest(bar.getOpenInterest());
        }
        BarUtils.doCalculateDelta(resultList);
        return resultList.stream().map(CoreField.BarField.Builder::build).toList();
    }

    private static void doCalculateDelta(List<CoreField.BarField.Builder> resultList) {
        if (resultList.size() > 1) {
            CoreField.BarField.Builder bb0 = resultList.get(resultList.size() - 1);
            CoreField.BarField.Builder bb1 = resultList.get(resultList.size() - 2);
            bb0.setVolumeDelta(bb0.getVolume() - bb1.getVolume());
            bb0.setOpenInterestDelta(bb0.getOpenInterest() - bb1.getOpenInterest());
            bb0.setNumTradesDelta(bb0.getNumTrades() - bb1.getNumTrades());
            bb0.setTurnoverDelta(bb0.getTurnover() - bb1.getTurnover());
        }
    }

    public static boolean isEndOfTheTradingDay(CoreField.BarField bar) {
        if (bar.getGatewayId().startsWith("CTP")) {
            boolean mostEndTime;
            boolean absEndTime = bar.getActionTime().startsWith("15:15");
            boolean bl = mostEndTime = bar.getActionTime().startsWith("15:00") && (!bar.getUnifiedSymbol().startsWith("T") || !bar.getUnifiedSymbol().contains(CoreEnum.ExchangeEnum.CFFEX.toString()));
            return mostEndTime || absEndTime;
        }
        return false;
    }
}

