/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.gateway.model;

import java.util.regex.Pattern;
import xyz.redtorch.pb.CoreEnum;

public class ContractDefinition {
    private CoreEnum.ProductClassEnum productClass;
    private CoreEnum.ExchangeEnum exchange;
    private Pattern symbolPattern;
    private double commissionFee;
    private double commissionRate;
    private String tradeTimeType;
    private String name;

    public static ContractDefinitionBuilder builder() {
        return new ContractDefinitionBuilder();
    }

    public ContractDefinition(CoreEnum.ProductClassEnum productClass, CoreEnum.ExchangeEnum exchange, Pattern symbolPattern, double commissionFee, double commissionRate, String tradeTimeType, String name) {
        this.productClass = productClass;
        this.exchange = exchange;
        this.symbolPattern = symbolPattern;
        this.commissionFee = commissionFee;
        this.commissionRate = commissionRate;
        this.tradeTimeType = tradeTimeType;
        this.name = name;
    }

    public CoreEnum.ProductClassEnum getProductClass() {
        return this.productClass;
    }

    public CoreEnum.ExchangeEnum getExchange() {
        return this.exchange;
    }

    public Pattern getSymbolPattern() {
        return this.symbolPattern;
    }

    public double getCommissionFee() {
        return this.commissionFee;
    }

    public double getCommissionRate() {
        return this.commissionRate;
    }

    public String getTradeTimeType() {
        return this.tradeTimeType;
    }

    public String getName() {
        return this.name;
    }

    public void setProductClass(CoreEnum.ProductClassEnum productClass) {
        this.productClass = productClass;
    }

    public void setExchange(CoreEnum.ExchangeEnum exchange) {
        this.exchange = exchange;
    }

    public void setSymbolPattern(Pattern symbolPattern) {
        this.symbolPattern = symbolPattern;
    }

    public void setCommissionFee(double commissionFee) {
        this.commissionFee = commissionFee;
    }

    public void setCommissionRate(double commissionRate) {
        this.commissionRate = commissionRate;
    }

    public void setTradeTimeType(String tradeTimeType) {
        this.tradeTimeType = tradeTimeType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContractDefinition)) {
            return false;
        }
        ContractDefinition other = (ContractDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getCommissionFee(), other.getCommissionFee()) != 0) {
            return false;
        }
        if (Double.compare(this.getCommissionRate(), other.getCommissionRate()) != 0) {
            return false;
        }
        CoreEnum.ProductClassEnum this$productClass = this.getProductClass();
        CoreEnum.ProductClassEnum other$productClass = other.getProductClass();
        if (this$productClass == null ? other$productClass != null : !((Object)((Object)this$productClass)).equals((Object)other$productClass)) {
            return false;
        }
        CoreEnum.ExchangeEnum this$exchange = this.getExchange();
        CoreEnum.ExchangeEnum other$exchange = other.getExchange();
        if (this$exchange == null ? other$exchange != null : !((Object)((Object)this$exchange)).equals((Object)other$exchange)) {
            return false;
        }
        Pattern this$symbolPattern = this.getSymbolPattern();
        Pattern other$symbolPattern = other.getSymbolPattern();
        if (this$symbolPattern == null ? other$symbolPattern != null : !this$symbolPattern.equals(other$symbolPattern)) {
            return false;
        }
        String this$tradeTimeType = this.getTradeTimeType();
        String other$tradeTimeType = other.getTradeTimeType();
        if (this$tradeTimeType == null ? other$tradeTimeType != null : !this$tradeTimeType.equals(other$tradeTimeType)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContractDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $commissionFee = Double.doubleToLongBits(this.getCommissionFee());
        result = result * 59 + (int)($commissionFee ^ $commissionFee >>> 32);
        long $commissionRate = Double.doubleToLongBits(this.getCommissionRate());
        result = result * 59 + (int)($commissionRate ^ $commissionRate >>> 32);
        CoreEnum.ProductClassEnum $productClass = this.getProductClass();
        result = result * 59 + ($productClass == null ? 43 : ((Object)((Object)$productClass)).hashCode());
        CoreEnum.ExchangeEnum $exchange = this.getExchange();
        result = result * 59 + ($exchange == null ? 43 : ((Object)((Object)$exchange)).hashCode());
        Pattern $symbolPattern = this.getSymbolPattern();
        result = result * 59 + ($symbolPattern == null ? 43 : $symbolPattern.hashCode());
        String $tradeTimeType = this.getTradeTimeType();
        result = result * 59 + ($tradeTimeType == null ? 43 : $tradeTimeType.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "ContractDefinition(productClass=" + (Object)((Object)this.getProductClass()) + ", exchange=" + (Object)((Object)this.getExchange()) + ", symbolPattern=" + this.getSymbolPattern() + ", commissionFee=" + this.getCommissionFee() + ", commissionRate=" + this.getCommissionRate() + ", tradeTimeType=" + this.getTradeTimeType() + ", name=" + this.getName() + ")";
    }

    public static class ContractDefinitionBuilder {
        private CoreEnum.ProductClassEnum productClass;
        private CoreEnum.ExchangeEnum exchange;
        private Pattern symbolPattern;
        private double commissionFee;
        private double commissionRate;
        private String tradeTimeType;
        private String name;

        ContractDefinitionBuilder() {
        }

        public ContractDefinitionBuilder productClass(CoreEnum.ProductClassEnum productClass) {
            this.productClass = productClass;
            return this;
        }

        public ContractDefinitionBuilder exchange(CoreEnum.ExchangeEnum exchange) {
            this.exchange = exchange;
            return this;
        }

        public ContractDefinitionBuilder symbolPattern(Pattern symbolPattern) {
            this.symbolPattern = symbolPattern;
            return this;
        }

        public ContractDefinitionBuilder commissionFee(double commissionFee) {
            this.commissionFee = commissionFee;
            return this;
        }

        public ContractDefinitionBuilder commissionRate(double commissionRate) {
            this.commissionRate = commissionRate;
            return this;
        }

        public ContractDefinitionBuilder tradeTimeType(String tradeTimeType) {
            this.tradeTimeType = tradeTimeType;
            return this;
        }

        public ContractDefinitionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ContractDefinition build() {
            return new ContractDefinition(this.productClass, this.exchange, this.symbolPattern, this.commissionFee, this.commissionRate, this.tradeTimeType, this.name);
        }

        public String toString() {
            return "ContractDefinition.ContractDefinitionBuilder(productClass=" + (Object)((Object)this.productClass) + ", exchange=" + (Object)((Object)this.exchange) + ", symbolPattern=" + this.symbolPattern + ", commissionFee=" + this.commissionFee + ", commissionRate=" + this.commissionRate + ", tradeTimeType=" + this.tradeTimeType + ", name=" + this.name + ")";
        }
    }
}

