/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.indicator.constant;

import xyz.redtorch.pb.CoreField;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ValueType {
    HIGH{

        @Override
        public double resolve(CoreField.BarField bar) {
            return bar.getHighPrice();
        }
    }
    ,
    LOW{

        @Override
        public double resolve(CoreField.BarField bar) {
            return bar.getLowPrice();
        }
    }
    ,
    OPEN{

        @Override
        public double resolve(CoreField.BarField bar) {
            return bar.getOpenPrice();
        }
    }
    ,
    CLOSE{

        @Override
        public double resolve(CoreField.BarField bar) {
            return bar.getClosePrice();
        }
    }
    ,
    BARYCENTER{

        @Override
        public double resolve(CoreField.BarField bar) {
            return (bar.getHighPrice() + bar.getClosePrice() + bar.getClosePrice() * 2.0) / 4.0;
        }
    }
    ,
    VOL{

        @Override
        public double resolve(CoreField.BarField bar) {
            return bar.getVolume();
        }
    }
    ,
    OI{

        @Override
        public double resolve(CoreField.BarField bar) {
            return bar.getOpenInterest();
        }
    }
    ,
    OI_DELTA{

        @Override
        public double resolve(CoreField.BarField bar) {
            return bar.getOpenInterestDelta();
        }
    }
    ,
    TRADE_DATE{

        @Override
        public double resolve(CoreField.BarField bar) {
            return Double.valueOf(bar.getTradingDay());
        }
    };


    public abstract double resolve(CoreField.BarField var1);
}

