/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.indicator.model;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class RingArray<T> {
    private T[] array;
    private int cursor;
    private boolean lastFlag = true;

    public RingArray(int size) {
        this.array = new Object[size];
    }

    public T get() {
        return this.get(0);
    }

    public T get(int index) {
        return this.array[this.getIndex(index)];
    }

    public Optional<T> update(T obj, boolean unstable) {
        if (unstable) {
            int index = this.lastFlag != unstable ? 1 : 0;
            this.lastFlag = unstable;
            return Optional.ofNullable(this.update(obj, index));
        }
        int index = this.lastFlag == unstable ? 1 : 0;
        this.lastFlag = unstable;
        return Optional.ofNullable(this.update(obj, index));
    }

    private T update(T obj, int index) {
        this.cursor = this.getIndex(index);
        T old = this.array[this.cursor];
        this.array[this.cursor] = obj;
        return old;
    }

    private int getIndex(int incr) {
        return (this.cursor + this.array.length + incr) % this.array.length;
    }

    public Object[] toArray() {
        Object[] result = new Object[this.array.length];
        int i = 0;
        while (i < this.array.length) {
            result[i] = this.get(-i);
            ++i;
        }
        return result;
    }

    public int size() {
        return (int)Stream.of(this.array).filter(Objects::nonNull).count();
    }

    public int length() {
        return this.array.length;
    }
}

