/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.indicator.trend;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.dromara.northstar.indicator.AbstractIndicator;
import org.dromara.northstar.indicator.Indicator;
import org.dromara.northstar.indicator.model.Configuration;
import org.dromara.northstar.indicator.model.Num;

public class EMAIndicator
extends AbstractIndicator
implements Indicator {
    private double factor;
    private Indicator srcIndicator;

    public EMAIndicator(Configuration cfg, int barCount) {
        super(cfg);
        this.factor = 2.0 / (double)(barCount + 1);
    }

    public EMAIndicator(Configuration cfg, Indicator indicator, int barCount) {
        this(cfg, barCount);
        this.srcIndicator = indicator;
    }

    @Override
    public List<Indicator> dependencies() {
        if (Objects.isNull(this.srcIndicator)) {
            return Collections.emptyList();
        }
        return List.of(this.srcIndicator);
    }

    @Override
    protected Num evaluate(Num num) {
        Num preVal;
        Num newVal;
        Num num2 = newVal = Objects.isNull(this.srcIndicator) ? num : this.srcIndicator.get(0);
        if (newVal.isNaN() || this.ringBuf.size() == 0 || this.ringBuf.size() == 1 && ((Num)this.ringBuf.get()).unstable()) {
            return newVal;
        }
        Num num3 = preVal = ((Num)this.ringBuf.get()).unstable() ? this.get(-1) : this.get(0);
        if (preVal.isNaN()) {
            return newVal;
        }
        double val = this.factor * newVal.value() + (1.0 - this.factor) * preVal.value();
        return Num.of(val, num.timestamp(), num.unstable());
    }
}

