/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.indicator.trend;

import java.util.List;
import org.dromara.northstar.indicator.AbstractIndicator;
import org.dromara.northstar.indicator.Indicator;
import org.dromara.northstar.indicator.helper.DiffIndicator;
import org.dromara.northstar.indicator.model.Configuration;
import org.dromara.northstar.indicator.model.Num;
import org.dromara.northstar.indicator.trend.EMAIndicator;
import org.springframework.util.Assert;

public class MACDIndicator
extends AbstractIndicator
implements Indicator {
    protected Indicator diffLine;
    protected Indicator deaLine;

    public MACDIndicator(Configuration cfg, int shortBarCount, int longBarCount, int signalBarCount) {
        super(cfg);
        Assert.isTrue((shortBarCount < longBarCount ? 1 : 0) != 0, (String)"\u957f\u77ed\u5468\u671f\u8bbe\u7f6e\u4e0d\u6b63\u786e");
        EMAIndicator shortTermLine = new EMAIndicator(cfg.toBuilder().indicatorName(String.valueOf(cfg.indicatorName()) + "_fast").visible(false).build(), shortBarCount);
        EMAIndicator longTermLine = new EMAIndicator(cfg.toBuilder().indicatorName(String.valueOf(cfg.indicatorName()) + "_slow").visible(false).build(), longBarCount);
        this.diffLine = new DiffIndicator(cfg.toBuilder().indicatorName(String.valueOf(cfg.indicatorName()) + "_diff").build(), shortTermLine, longTermLine);
        this.deaLine = new EMAIndicator(cfg.toBuilder().indicatorName(String.valueOf(cfg.indicatorName()) + "_dea").build(), this.diffLine, signalBarCount);
    }

    public MACDIndicator(Configuration cfg, Indicator fastLine, Indicator slowLine, int signalBarCount) {
        super(cfg);
        this.diffLine = new DiffIndicator(cfg.toBuilder().indicatorName(String.valueOf(cfg.indicatorName()) + "_diff").build(), fastLine, slowLine);
        this.deaLine = new EMAIndicator(cfg.toBuilder().indicatorName(String.valueOf(cfg.indicatorName()) + "_dea").build(), this.diffLine, signalBarCount);
    }

    @Override
    public List<Indicator> dependencies() {
        return List.of(this.deaLine);
    }

    @Override
    protected Num evaluate(Num num) {
        double val = (this.diffLine.value(0) - this.deaLine.value(0)) * 2.0;
        return Num.of(val, num.timestamp(), num.unstable());
    }

    public Indicator getDiffLine() {
        return this.diffLine;
    }

    public Indicator getDeaLine() {
        return this.deaLine;
    }
}

