/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.indicator.trend;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.dromara.northstar.indicator.AbstractIndicator;
import org.dromara.northstar.indicator.Indicator;
import org.dromara.northstar.indicator.model.Configuration;
import org.dromara.northstar.indicator.model.Num;
import org.springframework.util.Assert;

public class SMAIndicator
extends AbstractIndicator
implements Indicator {
    private double factor;
    private Indicator srcIndicator;

    public SMAIndicator(Configuration cfg, int barCount, int weight) {
        super(cfg);
        Assert.isTrue((barCount > weight ? 1 : 0) != 0, (String)"\u66f4\u65b0\u6743\u91cd\u8bbe\u7f6e\u5f02\u5e38");
        this.factor = (double)weight / (double)barCount;
    }

    public SMAIndicator(Configuration cfg, Indicator srcIndicator, int barCount, int weight) {
        this(cfg, barCount, weight);
        this.srcIndicator = srcIndicator;
    }

    @Override
    public List<Indicator> dependencies() {
        if (Objects.isNull(this.srcIndicator)) {
            return Collections.emptyList();
        }
        return List.of(this.srcIndicator);
    }

    @Override
    protected Num evaluate(Num num) {
        Num preVal;
        Num newVal;
        Num num2 = newVal = Objects.isNull(this.srcIndicator) ? num : this.srcIndicator.get(0);
        if (newVal.isNaN() || this.ringBuf.size() == 0 || this.ringBuf.size() == 1 && ((Num)this.ringBuf.get()).unstable()) {
            return newVal;
        }
        Num num3 = preVal = ((Num)this.ringBuf.get()).unstable() ? this.get(-1) : this.get(0);
        if (preVal.isNaN()) {
            return newVal;
        }
        double val = this.factor * newVal.value() + (1.0 - this.factor) * preVal.value();
        return Num.of(val, num.timestamp(), num.unstable());
    }
}

