/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.indicator.volatility;

import java.util.List;
import org.dromara.northstar.indicator.AbstractIndicator;
import org.dromara.northstar.indicator.Indicator;
import org.dromara.northstar.indicator.helper.DiffIndicator;
import org.dromara.northstar.indicator.helper.StandardDeviationIndicator;
import org.dromara.northstar.indicator.helper.SumIndicator;
import org.dromara.northstar.indicator.model.Configuration;
import org.dromara.northstar.indicator.model.Num;
import org.dromara.northstar.indicator.trend.MAIndicator;

public class BOLLIndicator
extends AbstractIndicator
implements Indicator {
    private static String ERR_MSG = "\u5e03\u6797\u5e26\u6307\u6807\u662f\u4e00\u4e2a\u591a\u503c\u6307\u6807\uff0c\u4e0d\u80fd\u76f4\u63a5\u8c03\u7528\u8be5\u6307\u6807\u65b9\u6cd5\uff0c\u5e94\u8be5\u83b7\u53d6\u5177\u6709\u7684\u6307\u6807\u7ebf\u8fdb\u884c\u8c03\u7528";
    private Indicator mid;
    private Indicator std;
    private Indicator upper;
    private Indicator lower;

    public BOLLIndicator(Configuration cfg, int barCount, double multipler) {
        super(cfg.toBuilder().visible(false).build());
        this.mid = new MAIndicator(cfg.toBuilder().indicatorName("BOLL_mid").numOfUnits(barCount).build(), barCount);
        this.std = new StandardDeviationIndicator(cfg.toBuilder().indicatorName("BOLL_std").build(), barCount);
        this.upper = new SumIndicator(cfg.toBuilder().indicatorName("BOLL_upper").numOfUnits(barCount).build(), this.mid, 1.0, this.std, multipler);
        this.lower = new DiffIndicator(cfg.toBuilder().indicatorName("BOLL_lower").numOfUnits(barCount).build(), this.mid, 1.0, this.std, multipler);
    }

    @Override
    public List<Indicator> dependencies() {
        return List.of(this.mid, this.upper, this.lower);
    }

    @Override
    protected Num evaluate(Num num) {
        return this.std.get(0);
    }

    @Override
    public Num get(int step) {
        throw new UnsupportedOperationException(ERR_MSG);
    }

    @Override
    public double value(int step) {
        throw new UnsupportedOperationException(ERR_MSG);
    }

    @Override
    public List<Num> getData() {
        throw new UnsupportedOperationException(ERR_MSG);
    }

    public Indicator getMid() {
        return this.mid;
    }

    public Indicator getUpper() {
        return this.upper;
    }

    public Indicator getLower() {
        return this.lower;
    }
}

