/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.indicator.volatility;

import java.util.List;
import org.dromara.northstar.indicator.AbstractIndicator;
import org.dromara.northstar.indicator.Indicator;
import org.dromara.northstar.indicator.constant.ValueType;
import org.dromara.northstar.indicator.helper.SimpleValueIndicator;
import org.dromara.northstar.indicator.model.Configuration;
import org.dromara.northstar.indicator.model.Num;

public class TrueRangeIndicator
extends AbstractIndicator
implements Indicator {
    private Indicator close;
    private Indicator high;
    private Indicator low;

    public TrueRangeIndicator(Configuration cfg) {
        super(cfg);
        this.close = new SimpleValueIndicator(cfg.toBuilder().valueType(ValueType.CLOSE).visible(false).build());
        this.high = new SimpleValueIndicator(cfg.toBuilder().valueType(ValueType.HIGH).visible(false).build());
        this.low = new SimpleValueIndicator(cfg.toBuilder().valueType(ValueType.LOW).visible(false).build());
    }

    @Override
    public List<Indicator> dependencies() {
        return List.of(this.close, this.high, this.low);
    }

    @Override
    protected Num evaluate(Num num) {
        if (!this.close.isReady()) {
            return Num.NaN();
        }
        double difHighLow = this.high.value(0) - this.low.value(0);
        double difHighClose = Math.abs(this.high.value(0) - this.close.value(-1));
        double difLowClose = Math.abs(this.low.value(0) - this.close.value(-1));
        return Num.of(Math.max(difHighLow, Math.max(difHighClose, difLowClose)), num.timestamp(), num.unstable());
    }
}

