/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.indicator.wave;

import java.util.List;
import java.util.Objects;
import org.dromara.northstar.indicator.AbstractIndicator;
import org.dromara.northstar.indicator.Indicator;
import org.dromara.northstar.indicator.constant.ValueType;
import org.dromara.northstar.indicator.helper.SimpleValueIndicator;
import org.dromara.northstar.indicator.model.Configuration;
import org.dromara.northstar.indicator.model.Num;
import org.springframework.util.Assert;

public class MABasedWaveIndicator
extends AbstractIndicator
implements Indicator {
    private int numOfBarToConfirmTheSegment;
    private EndpointType type;
    private Boolean isGoingUp;
    private Double sectionMax;
    private Double sectionMin;
    private Indicator high;
    private Indicator low;
    private Indicator maLine;
    private Indicator close;

    public MABasedWaveIndicator(Configuration cfg, Indicator maLine, int numOfBarToConfirmTheSegment, EndpointType type) {
        super(cfg);
        this.numOfBarToConfirmTheSegment = numOfBarToConfirmTheSegment;
        this.type = type;
        this.maLine = maLine;
        this.close = new SimpleValueIndicator(cfg.toBuilder().valueType(ValueType.CLOSE).visible(false).build());
        this.high = new SimpleValueIndicator(cfg.toBuilder().valueType(ValueType.HIGH).visible(false).build());
        this.low = new SimpleValueIndicator(cfg.toBuilder().valueType(ValueType.LOW).visible(false).build());
        Assert.isTrue((maLine.getConfiguration().cacheLength() > numOfBarToConfirmTheSegment ? 1 : 0) != 0, (String)"\u53ef\u56de\u6eaf\u957f\u5ea6\u4e0d\u8db3\u4ee5\u786e\u5b9a\u6ce2\u6d6a");
        Assert.isTrue((cfg.cacheLength() > numOfBarToConfirmTheSegment ? 1 : 0) != 0, (String)"\u53ef\u56de\u6eaf\u957f\u5ea6\u4e0d\u8db3\u4ee5\u786e\u5b9a\u6ce2\u6d6a");
    }

    @Override
    public List<Indicator> dependencies() {
        return List.of(this.close, this.high, this.low, this.maLine);
    }

    @Override
    protected Num evaluate(Num num) {
        int i;
        boolean isValidTurnAround;
        if (!this.maLine.isReady() || num.unstable()) {
            return Num.NaN();
        }
        if (Objects.isNull(this.isGoingUp)) {
            this.isGoingUp = this.close.value(0) > this.maLine.value(0);
        }
        if (Objects.isNull(this.sectionMax)) {
            this.sectionMax = this.type == EndpointType.CLOSE ? this.close.value(0) : this.high.value(0);
        }
        if (Objects.isNull(this.sectionMin)) {
            this.sectionMin = this.type == EndpointType.CLOSE ? this.close.value(0) : this.low.value(0);
        }
        if (this.isGoingUp.booleanValue()) {
            this.sectionMax = this.type == EndpointType.CLOSE ? Math.max(this.sectionMax, this.close.value(0)) : Math.max(this.sectionMax, this.high.value(0));
        } else {
            this.sectionMin = this.type == EndpointType.CLOSE ? Math.min(this.sectionMin, this.close.value(0)) : Math.min(this.sectionMin, this.low.value(0));
        }
        if (this.isGoingUp.booleanValue() && this.close.value(-this.numOfBarToConfirmTheSegment) > this.maLine.value(-this.numOfBarToConfirmTheSegment)) {
            isValidTurnAround = true;
            i = 0;
            while (i < this.numOfBarToConfirmTheSegment) {
                if (this.close.value(-i) > this.maLine.value(-i)) {
                    isValidTurnAround = false;
                    break;
                }
                ++i;
            }
            if (isValidTurnAround) {
                this.isGoingUp = false;
                this.sectionMin = this.sectionMax;
                return Num.of(this.sectionMax, num.timestamp(), num.unstable());
            }
        }
        if (!this.isGoingUp.booleanValue() && this.close.value(-this.numOfBarToConfirmTheSegment) < this.maLine.value(-this.numOfBarToConfirmTheSegment)) {
            isValidTurnAround = true;
            i = 0;
            while (i < this.numOfBarToConfirmTheSegment) {
                if (this.close.value(-i) < this.maLine.value(-i)) {
                    isValidTurnAround = false;
                    break;
                }
                ++i;
            }
            if (isValidTurnAround) {
                this.isGoingUp = true;
                this.sectionMax = this.sectionMin;
                return Num.of(this.sectionMin, num.timestamp(), num.unstable());
            }
        }
        return Num.NaN();
    }

    public static enum EndpointType {
        CLOSE,
        HIGH_LOW;

    }
}

