/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.strategy.constant;

import lombok.Generated;
import org.dromara.northstar.common.constant.SignalOperation;
import xyz.redtorch.pb.CoreField;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PriceType {
    ANY_PRICE("\u5e02\u4ef7"){

        @Override
        public double resolvePrice(CoreField.TickField tick, SignalOperation operation, double price) {
            return 0.0;
        }
    }
    ,
    OPP_PRICE("\u5bf9\u624b\u4ef7"){

        @Override
        public double resolvePrice(CoreField.TickField tick, SignalOperation operation, double price) {
            return operation.isBuy() ? tick.getAskPrice(0) : tick.getBidPrice(0);
        }
    }
    ,
    LAST_PRICE("\u6700\u65b0\u4ef7"){

        @Override
        public double resolvePrice(CoreField.TickField tick, SignalOperation operation, double price) {
            return tick.getLastPrice();
        }
    }
    ,
    WAITING_PRICE("\u6392\u961f\u4ef7"){

        @Override
        public double resolvePrice(CoreField.TickField tick, SignalOperation operation, double price) {
            return operation.isBuy() ? tick.getBidPrice(0) : tick.getAskPrice(0);
        }
    }
    ,
    LIMIT_PRICE("\u9650\u4ef7"){

        @Override
        public double resolvePrice(CoreField.TickField tick, SignalOperation operation, double price) {
            return price;
        }
    };

    private String name;

    private PriceType(String name) {
        this.name = name;
    }

    public abstract double resolvePrice(CoreField.TickField var1, SignalOperation var2, double var3);

    @Generated
    public String getName() {
        return this.name;
    }
}

