/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalEnvUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalEnvUtils.class);

    private LocalEnvUtils() {
    }

    public static String getPCName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "unknowHost";
        }
    }

    public static String getMACAddress() {
        try {
            byte[] hardwareAddress = LocalEnvUtils.getMACAddressBytes();
            CharSequence[] hexadecimalFormat = new String[hardwareAddress.length];
            for (int i = 0; i < hardwareAddress.length; ++i) {
                hexadecimalFormat[i] = String.format("%02X", hardwareAddress[i]);
            }
            return String.join((CharSequence)"-", hexadecimalFormat);
        }
        catch (Exception e) {
            log.warn("\u65e0\u6cd5\u83b7\u53d6MAC\u5730\u5740", (Throwable)e);
            return "";
        }
    }

    private static byte[] getMACAddressBytes() throws SocketException, UnknownHostException {
        byte[] hardwareAddress = NetworkInterface.getByInetAddress(InetAddress.getLocalHost()).getHardwareAddress();
        if (hardwareAddress != null) {
            return hardwareAddress;
        }
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface ni = networkInterfaces.nextElement();
            hardwareAddress = ni.getHardwareAddress();
            if (hardwareAddress == null) continue;
            return hardwareAddress;
        }
        throw new IllegalStateException("\u6ca1\u6709\u67e5\u5230MAC\u4fe1\u606f");
    }
}

